/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.http.internal.listener.DefaultHttpListener;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.module.http.internal.listener.ListenerPath;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class HttpListenerTestCase
extends AbstractMuleTestCase {
    public static final String URI_PARAM_NAME = "uri-param-name";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private DefaultHttpListenerConfig mockHttpListenerConfig = (DefaultHttpListenerConfig)Mockito.mock(DefaultHttpListenerConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private HttpListenerConnectionManager mockHttpListenerConnectionManager = (HttpListenerConnectionManager)Mockito.mock(HttpListenerConnectionManager.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Test
    public void cannotHaveTwoUriParamsWithSameName() throws Exception {
        String listenerPath = String.format("/{%s}/{%s}", URI_PARAM_NAME, URI_PARAM_NAME);
        this.useInvalidPath(listenerPath);
    }

    @Test
    public void cannotHaveWildcardWithOtherCharacters() throws Exception {
        this.useInvalidPath("/path/*pepe");
    }

    private void useInvalidPath(String listenerPath) throws InitialisationException {
        DefaultHttpListener httpListener = new DefaultHttpListener();
        httpListener.setMuleContext(this.mockMuleContext);
        httpListener.setFlowConstruct(this.mockFlowConstruct);
        httpListener.setConfig(this.mockHttpListenerConfig);
        Mockito.when((Object)this.mockHttpListenerConfig.getFullListenerPath(Matchers.anyString())).thenReturn((Object)new ListenerPath(null, listenerPath));
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_httpListenerConnectionManager")).thenReturn((Object)this.mockHttpListenerConnectionManager);
        httpListener.setPath(listenerPath);
        this.expectedException.expect(InitialisationException.class);
        httpListener.initialise();
    }
}

