/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.api.MuleRuntimeException;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.listener.HttpListenerRegistry;
import org.mule.module.http.internal.listener.NoListenerRequestHandler;
import org.mule.module.http.internal.listener.Server;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.matcher.AcceptsAllMethodsRequestMatcher;
import org.mule.module.http.internal.listener.matcher.ListenerRequestMatcher;
import org.mule.module.http.internal.listener.matcher.MethodRequestMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class HttpListenerRegistryTestCase
extends AbstractMuleTestCase {
    public static final String TEST_IP = "127.0.0.1";
    public static final String URI_PARAM = "{uri-param}";
    public static final int TEST_PORT = 10000;
    public static final String ANOTHER_PATH = "/another-path";
    public static final String SOME_PATH = "some-path";
    public static final String SOME_OTHER_PATH = "some-other-path";
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    public static final String PUT_METHOD = "PUT";
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_PATH = "/";
    public static final String FIRST_LEVEL_PATH_LOWER_CASE = "/first-level-path";
    public static final String FIRST_LEVEL_PATH_UPPER_CASE = "/FIRST_LEVEL_PATH";
    public static final String FIRST_LEVEL_PATH_UPPER_CASE_CATCH_ALL = "/FIRST_LEVEL_PATH/*";
    public static final String SECOND_LEVEL_PATH = "/first-level-path/second-level";
    public static final String FIRST_LEVEL_URI_PARAM = "/{uri-param}";
    public static final String FIRST_LEVEL_CATCH_ALL = "/*";
    public static final String SECOND_LEVEL_URI_PARAM = "/first-level-path/{uri-param}";
    public static final String SECOND_LEVEL_CATCH_ALL = "/first-level-path/*";
    public static final String FOURTH_LEVEL_CATCH_ALL = "/another-first-level-path/second-level-path/third-level-path/*";
    public static final String URI_PARAM_IN_THE_MIDDLE = "/first-level-path/{uri-param}/third-level-path";
    public static final String CATCH_ALL_IN_THE_MIDDLE = "/first-level-path/*/third-level-path";
    public static final String CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION = "/another-first-level-path/*/third-level-path";
    public static final String SEVERAL_URI_PARAMS = "/{uri-param1}/second-level-path/{uri-param2}/fourth-level-path";
    public static final String SEVERAL_CATCH_ALL = "/*/second-level-path/*/fourth-level-path";
    public static final String METHOD_PATH_WILDCARD = "/method-path/*/";
    public static final String METHOD_PATH_URI_PARAM = "/another-method-path/{uri-param}/some-path";
    public static final String METHOD_PATH_CATCH_ALL = "/another-method-path/some-path/*";
    public static final String WILDCARD_CHARACTER = "*";
    public final RequestHandler methodPathWildcardGetRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathWildcardPostRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathUriParamGetRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathUriParamPostRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathCatchAllGetRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    public final RequestHandler methodPathCatchAllPostRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    private final ServerAddress testServerAddress = new ServerAddress("127.0.0.1", 10000);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private RequestHandler mockRequestHandler = (RequestHandler)Mockito.mock(RequestHandler.class);
    private Map<String, RequestHandler> requestHandlerPerPath = new HashMap<String, RequestHandler>();
    private HttpListenerRegistry httpListenerRegistry;
    private Server testServer;

    @Before
    public void createMockTestServer() {
        this.testServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)this.testServer.getServerAddress()).thenReturn((Object)this.testServerAddress);
    }

    @Test
    public void validateSimplePathAndAllMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), ANOTHER_PATH));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), ANOTHER_PATH));
    }

    @Test
    public void validateUriParamPathAndAllMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_URI_PARAM));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_URI_PARAM));
    }

    @Test
    public void validateCatchAllPathAndAllMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_CATCH_ALL));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), SECOND_LEVEL_CATCH_ALL));
    }

    @Test
    public void validateCatchAllPathAndMethodAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{GET_METHOD}), SECOND_LEVEL_CATCH_ALL));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{GET_METHOD}), SECOND_LEVEL_CATCH_ALL));
    }

    @Test
    public void validateCatchAllPathAndMethodIntersectionAllowedCollision() {
        HttpListenerRegistry httpListenerRegister = new HttpListenerRegistry();
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{GET_METHOD, POST_METHOD}), SECOND_LEVEL_CATCH_ALL));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegister.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{PUT_METHOD, POST_METHOD}), SECOND_LEVEL_CATCH_ALL));
    }

    @Test
    public void validateRootPathCollision() {
        this.validateCollision("/", "/");
    }

    @Test
    public void validateFirstLevelPathCollision() {
        this.validateCollision(FIRST_LEVEL_PATH_LOWER_CASE, FIRST_LEVEL_PATH_LOWER_CASE);
    }

    @Test
    public void validateSecondLevelPathCollision() {
        this.validateCollision(SECOND_LEVEL_PATH, SECOND_LEVEL_PATH);
    }

    @Test
    public void validateNoCollisionWithSpecificAndCatchAll() {
        this.validateNoCollision(FIRST_LEVEL_CATCH_ALL, FIRST_LEVEL_PATH_LOWER_CASE);
    }

    @Test
    public void validateNoCollisionWithSpecificAndUriParameter() {
        this.validateNoCollision(FIRST_LEVEL_URI_PARAM, FIRST_LEVEL_PATH_LOWER_CASE);
    }

    @Test
    public void validateCollisionWithRootLevelCatchAllAndRootLevelCatchAll() {
        this.validateCollision(FIRST_LEVEL_CATCH_ALL, FIRST_LEVEL_CATCH_ALL);
    }

    @Test
    public void validateCollisionWithRootLevelUriParamAndRootLevelUriParam() {
        this.validateCollision(FIRST_LEVEL_URI_PARAM, FIRST_LEVEL_URI_PARAM);
    }

    @Test
    public void validateCollisionWithSecondLevelCatchAllAndSecondLevelCatchAll() {
        this.validateCollision(SECOND_LEVEL_CATCH_ALL, SECOND_LEVEL_CATCH_ALL);
    }

    @Test
    public void validateCollisionWithSecondLevelUriParamAndSecondLevelUriParam() {
        this.validateCollision(SECOND_LEVEL_URI_PARAM, SECOND_LEVEL_URI_PARAM);
    }

    @Test
    public void validateUriParamAndCatchAllInTheMiddle() {
        this.validateCollision(URI_PARAM_IN_THE_MIDDLE, CATCH_ALL_IN_THE_MIDDLE);
    }

    @Test
    public void validateUriParamAndUriParamInTheMiddle() {
        this.validateCollision(URI_PARAM_IN_THE_MIDDLE, URI_PARAM_IN_THE_MIDDLE);
    }

    @Test
    public void validateCatchAllAndUriParamInTheMiddle() {
        this.validateCollision(CATCH_ALL_IN_THE_MIDDLE, URI_PARAM_IN_THE_MIDDLE);
    }

    @Test
    public void validateCatchAllAndCatchAllInTheMiddle() {
        this.validateCollision(CATCH_ALL_IN_THE_MIDDLE, CATCH_ALL_IN_THE_MIDDLE);
    }

    @Test
    public void validateSeveralUriParamsAndSeveralUriParams() {
        this.validateCollision(SEVERAL_URI_PARAMS, SEVERAL_URI_PARAMS);
    }

    @Test
    public void validateSeveralUriParamsAndSeveralCatchAll() {
        this.validateCollision(SEVERAL_URI_PARAMS, SEVERAL_CATCH_ALL);
    }

    @Test
    public void validateSeveralCatchAllAndSeveralUriParams() {
        this.validateCollision(SEVERAL_CATCH_ALL, SEVERAL_URI_PARAMS);
    }

    @Test
    public void validateSeveralCatchAllAndSeveralCatchAll() {
        this.validateCollision(SEVERAL_CATCH_ALL, SEVERAL_CATCH_ALL);
    }

    @Test
    public void noCollisionWithCaseSensitivePaths() {
        this.validateNoCollision(FIRST_LEVEL_PATH_LOWER_CASE, FIRST_LEVEL_PATH_UPPER_CASE);
    }

    @Test
    public void routeToCorrectHandler() {
        this.httpListenerRegistry = this.createHttpListenerRegistryWithRegisteredHandlers();
        this.routePath("/", "/");
        this.routePath("/something", FIRST_LEVEL_CATCH_ALL);
        this.routePath("/something/else", FIRST_LEVEL_CATCH_ALL);
        this.routePath("/first-level-path/second-level/somethingElse", FIRST_LEVEL_CATCH_ALL);
        this.routePath("/first-level-path/second-levelsomethingElse", SECOND_LEVEL_URI_PARAM);
        this.routePath(FIRST_LEVEL_PATH_LOWER_CASE, FIRST_LEVEL_PATH_LOWER_CASE);
        this.routePath("/first-level-path/", FIRST_LEVEL_PATH_LOWER_CASE);
        this.routePath(FIRST_LEVEL_PATH_UPPER_CASE, FIRST_LEVEL_PATH_UPPER_CASE);
        this.routePath("/FIRST_LEVEL_PATH/", FIRST_LEVEL_PATH_UPPER_CASE);
        this.routePath("/FIRST_LEVEL_PATH/somethingElse", FIRST_LEVEL_PATH_UPPER_CASE_CATCH_ALL);
        this.routePath(SECOND_LEVEL_PATH, SECOND_LEVEL_PATH);
        this.routePath(SECOND_LEVEL_URI_PARAM.replace(URI_PARAM, "1"), SECOND_LEVEL_URI_PARAM);
        this.routePath(FOURTH_LEVEL_CATCH_ALL.replace(WILDCARD_CHARACTER, ""), FOURTH_LEVEL_CATCH_ALL);
        this.routePath(FOURTH_LEVEL_CATCH_ALL.replace(WILDCARD_CHARACTER, "foo1/foo2"), FOURTH_LEVEL_CATCH_ALL);
        this.routePath(URI_PARAM_IN_THE_MIDDLE.replace(URI_PARAM, "1"), URI_PARAM_IN_THE_MIDDLE);
        this.routePath(URI_PARAM_IN_THE_MIDDLE.replace(URI_PARAM, "1") + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION.replace(WILDCARD_CHARACTER, SOME_PATH), CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION);
        this.routePath(CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION.replace(WILDCARD_CHARACTER, SOME_PATH) + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(SEVERAL_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH), SEVERAL_CATCH_ALL);
        this.routePath(SEVERAL_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH) + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(SEVERAL_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH) + ANOTHER_PATH, FIRST_LEVEL_CATCH_ALL);
        this.routePath(METHOD_PATH_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH), GET_METHOD, this.methodPathCatchAllGetRequestHandler);
        this.routePath(METHOD_PATH_CATCH_ALL.replace(WILDCARD_CHARACTER, SOME_PATH), POST_METHOD, this.methodPathCatchAllPostRequestHandler);
        this.routePath(METHOD_PATH_URI_PARAM.replace(URI_PARAM, SOME_OTHER_PATH), GET_METHOD, this.methodPathUriParamGetRequestHandler);
        this.routePath(METHOD_PATH_URI_PARAM.replace(URI_PARAM, SOME_OTHER_PATH), POST_METHOD, this.methodPathUriParamPostRequestHandler);
        this.routePath(METHOD_PATH_WILDCARD.replace(WILDCARD_CHARACTER, SOME_PATH), GET_METHOD, this.methodPathWildcardGetRequestHandler);
        this.routePath(METHOD_PATH_WILDCARD.replace(WILDCARD_CHARACTER, SOME_PATH), POST_METHOD, this.methodPathWildcardPostRequestHandler);
    }

    @Test
    public void noPathFound() {
        this.httpListenerRegistry = new HttpListenerRegistry();
        this.httpListenerRegistry.addRequestHandler(this.testServer, (RequestHandler)Mockito.mock(RequestHandler.class), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), "/"));
        RequestHandler requestHandler = this.httpListenerRegistry.getRequestHandler(TEST_IP, 10000, this.createMockRequestWithPath(ANOTHER_PATH));
        Assert.assertThat((Object)requestHandler, (Matcher)Is.is((Matcher)Matchers.instanceOf(NoListenerRequestHandler.class)));
    }

    private void routePath(String requestPath, String listenerPath) {
        Assert.assertThat((Object)this.httpListenerRegistry.getRequestHandler(TEST_IP, 10000, this.createMockRequestWithPath(requestPath)), (Matcher)Is.is((Object)this.requestHandlerPerPath.get(listenerPath)));
    }

    private void routePath(String requestPath, String requestMethod, RequestHandler expectedRequestHandler) {
        HttpRequest mockRequest = this.createMockRequestWithPath(requestPath);
        Mockito.when((Object)mockRequest.getMethod()).thenReturn((Object)requestMethod);
        Assert.assertThat((Object)this.httpListenerRegistry.getRequestHandler(TEST_IP, 10000, mockRequest), (Matcher)Is.is((Object)expectedRequestHandler));
    }

    private HttpRequest createMockRequestWithPath(String path) {
        HttpRequest mockRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)mockRequest.getPath()).thenReturn((Object)path);
        return mockRequest;
    }

    private HttpListenerRegistry createHttpListenerRegistryWithRegisteredHandlers() {
        HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
        this.requestHandlerPerPath.put("/", (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_PATH_LOWER_CASE, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_PATH_UPPER_CASE, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FIRST_LEVEL_PATH_UPPER_CASE_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(SECOND_LEVEL_PATH, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(SECOND_LEVEL_URI_PARAM, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(FOURTH_LEVEL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(URI_PARAM_IN_THE_MIDDLE, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(CATCH_ALL_IN_THE_MIDDLE_NO_COLLISION, (RequestHandler)Mockito.mock(RequestHandler.class));
        this.requestHandlerPerPath.put(SEVERAL_CATCH_ALL, (RequestHandler)Mockito.mock(RequestHandler.class));
        for (String path : this.requestHandlerPerPath.keySet()) {
            httpListenerRegistry.addRequestHandler(this.testServer, this.requestHandlerPerPath.get(path), new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path));
        }
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathUriParamGetRequestHandler, new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{GET_METHOD}), METHOD_PATH_URI_PARAM));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathUriParamPostRequestHandler, new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{POST_METHOD}), METHOD_PATH_URI_PARAM));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathCatchAllGetRequestHandler, new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{GET_METHOD}), METHOD_PATH_CATCH_ALL));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathCatchAllPostRequestHandler, new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{POST_METHOD}), METHOD_PATH_CATCH_ALL));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathWildcardGetRequestHandler, new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{GET_METHOD}), METHOD_PATH_WILDCARD));
        httpListenerRegistry.addRequestHandler(this.testServer, this.methodPathWildcardPostRequestHandler, new ListenerRequestMatcher(new MethodRequestMatcher(new String[]{POST_METHOD}), METHOD_PATH_WILDCARD));
        return httpListenerRegistry;
    }

    private void validateNoCollision(String ... paths) {
        HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
        for (String path : paths) {
            httpListenerRegistry.addRequestHandler(this.testServer, this.mockRequestHandler, new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), path));
        }
    }

    private void validateCollision(String firstPath, String secondPath) {
        HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
        httpListenerRegistry.addRequestHandler(this.testServer, this.mockRequestHandler, new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), firstPath));
        this.expectedException.expect(MuleRuntimeException.class);
        httpListenerRegistry.addRequestHandler(this.testServer, this.mockRequestHandler, new ListenerRequestMatcher((MethodRequestMatcher)AcceptsAllMethodsRequestMatcher.instance(), secondPath));
    }
}

