/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManagerSource;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.tcp.TcpServerSocketProperties;

public class HttpListenerConnectionManagerTestCase
extends AbstractMuleTestCase {
    private static final String SPECIFIC_IP = "172.24.24.1";
    public static final int PORT = 5555;
    public static final int CONNECTION_IDLE_TIMEOUT = 1000;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void initializationFailsWhenHostIsRepeated() throws Exception {
        this.testInitialization(SPECIFIC_IP, SPECIFIC_IP);
    }

    @Test
    public void initializationFailsWhenSpecificHostIsOverlapping() throws Exception {
        this.testInitialization("0.0.0.0", SPECIFIC_IP);
    }

    @Test
    public void initializationFailsWhenAllInterfacesIsOverlapping() throws Exception {
        this.testInitialization(SPECIFIC_IP, "0.0.0.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInitialization(String firstIp, String secondIp) throws MuleException {
        HttpListenerConnectionManager connectionManager = new HttpListenerConnectionManager();
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        connectionManager.setMuleContext(mockMuleContext);
        WorkManagerSource mockWorkManagerSource = (WorkManagerSource)Mockito.mock(WorkManagerSource.class);
        Mockito.when((Object)mockMuleContext.getRegistry().lookupObject(TcpServerSocketProperties.class)).thenReturn(Mockito.mock(TcpServerSocketProperties.class));
        connectionManager.initialise();
        connectionManager.createServer(new ServerAddress(firstIp, 5555), mockWorkManagerSource, false, 1000);
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage(String.format("A server in port(%s) already exists for ip(%s) or one overlapping it (0.0.0.0).", 5555, secondIp));
        try {
            connectionManager.createServer(new ServerAddress(secondIp, 5555), mockWorkManagerSource, false, 1000);
        }
        finally {
            connectionManager.dispose();
        }
    }
}

