/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ssl.api.TlsContextFactory;

@SmallTest
public class HttpListenerConfigTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void initializationFailsWhenNoTlsKeyStoreConfigured() throws Exception {
        DefaultHttpListenerConfig httpListenerConfig = new DefaultHttpListenerConfig();
        httpListenerConfig.setProtocol(HttpConstants.Protocols.HTTPS);
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        httpListenerConfig.setMuleContext(mockMuleContext);
        TlsContextFactory mockTlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
        httpListenerConfig.setTlsContext(mockTlsContextFactory);
        Mockito.when((Object)mockMuleContext.getRegistry().lookupObject(HttpListenerConnectionManager.class)).thenReturn(Mockito.mock(HttpListenerConnectionManager.class));
        Mockito.when((Object)mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)false);
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"KeyStore must be configured for server side SSL"));
        httpListenerConfig.initialise();
    }
}

