/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ssl.api.TlsContextFactory;

@SmallTest
public class DefaultHttpListenerConfigTestCase
extends AbstractMuleTestCase {
    private static final String LOCALHOST = "localhost";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private HttpListenerConnectionManager mockHttpListenerConnectionManager = (HttpListenerConnectionManager)Mockito.mock(HttpListenerConnectionManager.class);
    private TlsContextFactory mockTlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
    private DefaultHttpListenerConfig listenerConfig;

    @Before
    public void setUp() throws RegistrationException {
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObject(HttpListenerConnectionManager.class)).thenReturn((Object)this.mockHttpListenerConnectionManager);
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        this.listenerConfig = this.createBaseListener();
    }

    @Test
    public void defaultPortWithDefaultProtocol() throws Exception {
        this.listenerConfig.initialise();
        Assert.assertThat((Object)this.listenerConfig.getPort(), (Matcher)Is.is((Object)HttpConstants.Protocols.HTTP.getDefaultPort()));
    }

    @Test
    public void defaultPortWithHttpConfigured() throws Exception {
        this.listenerConfig.setProtocol(HttpConstants.Protocols.HTTP);
        this.listenerConfig.initialise();
        Assert.assertThat((Object)this.listenerConfig.getPort(), (Matcher)Is.is((Object)HttpConstants.Protocols.HTTP.getDefaultPort()));
    }

    @Test
    public void defaultPortWithHttpsConfigured() throws Exception {
        this.listenerConfig.setProtocol(HttpConstants.Protocols.HTTPS);
        this.listenerConfig.setTlsContext(this.mockTlsContextFactory);
        this.listenerConfig.initialise();
        Assert.assertThat((Object)this.listenerConfig.getPort(), (Matcher)Is.is((Object)HttpConstants.Protocols.HTTPS.getDefaultPort()));
    }

    @Test
    public void validateTlsContextWhenUsingHttps() throws Exception {
        this.listenerConfig.setProtocol(HttpConstants.Protocols.HTTPS);
        this.expectedException.expect(InitialisationException.class);
        this.listenerConfig.initialise();
    }

    @Test
    public void validateTlsContextWithNoKeystoreWhenUsingHttps() throws Exception {
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)false);
        this.listenerConfig.setProtocol(HttpConstants.Protocols.HTTPS);
        this.expectedException.expect(InitialisationException.class);
        this.listenerConfig.initialise();
    }

    private DefaultHttpListenerConfig createBaseListener() {
        DefaultHttpListenerConfig listenerConfig = new DefaultHttpListenerConfig(this.mockHttpListenerConnectionManager);
        listenerConfig.setHost(LOCALHOST);
        listenerConfig.setMuleContext(this.mockMuleContext);
        return listenerConfig;
    }
}

