/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.config;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.module.http.internal.config.HttpConfiguration;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class HttpConfigurationTestCase
extends AbstractMuleTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private HttpConfiguration httpConfiguration = new HttpConfiguration();

    @Test
    public void defaultIsUseNewModule() {
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getExtension(HttpConfiguration.class)).thenReturn(null);
        Assert.assertThat((Object)HttpConfiguration.useTransportForUris((MuleContext)this.mockMuleContext), (Matcher)Is.is((Object)false));
    }

    @Test
    public void noSystemPropertyAndNoConfig() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getExtension(HttpConfiguration.class)).thenReturn(null);
        Assert.assertThat((Object)HttpConfiguration.useTransportForUris((MuleContext)this.mockMuleContext), (Matcher)Is.is((Object)false));
    }

    @Test
    public void systemPropertyWithNoConfig() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.useTransportForUris", (String)Boolean.TRUE.toString(), (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                Mockito.when((Object)HttpConfigurationTestCase.this.mockMuleContext.getConfiguration().getExtension(HttpConfiguration.class)).thenReturn(null);
                Assert.assertThat((Object)HttpConfiguration.useTransportForUris((MuleContext)HttpConfigurationTestCase.this.mockMuleContext), (Matcher)Is.is((Object)true));
            }
        });
    }

    @Test
    public void systemPropertyTrueButConfigWithFalse() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.useTransportForUris", (String)Boolean.TRUE.toString(), (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                Mockito.when((Object)HttpConfigurationTestCase.this.mockMuleContext.getConfiguration().getExtension(HttpConfiguration.class)).thenReturn((Object)HttpConfigurationTestCase.this.httpConfiguration);
                HttpConfigurationTestCase.this.httpConfiguration.setUseTransportForUris(false);
                Assert.assertThat((Object)HttpConfiguration.useTransportForUris((MuleContext)HttpConfigurationTestCase.this.mockMuleContext), (Matcher)Is.is((Object)false));
            }
        });
    }

    @Test
    public void systemPropertyFalseAndConfigWithFalse() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.useTransportForUris", (String)Boolean.FALSE.toString(), (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                Mockito.when((Object)HttpConfigurationTestCase.this.mockMuleContext.getConfiguration().getExtension(HttpConfiguration.class)).thenReturn((Object)HttpConfigurationTestCase.this.httpConfiguration);
                HttpConfigurationTestCase.this.httpConfiguration.setUseTransportForUris(false);
                Assert.assertThat((Object)HttpConfiguration.useTransportForUris((MuleContext)HttpConfigurationTestCase.this.mockMuleContext), (Matcher)Is.is((Object)false));
            }
        });
    }

    @Test
    public void systemPropertyFalseButConfigWithTrue() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.useTransportForUris", (String)Boolean.FALSE.toString(), (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                Mockito.when((Object)HttpConfigurationTestCase.this.mockMuleContext.getConfiguration().getExtension(HttpConfiguration.class)).thenReturn((Object)HttpConfigurationTestCase.this.httpConfiguration);
                HttpConfigurationTestCase.this.httpConfiguration.setUseTransportForUris(true);
                Assert.assertThat((Object)HttpConfiguration.useTransportForUris((MuleContext)HttpConfigurationTestCase.this.mockMuleContext), (Matcher)Is.is((Object)true));
            }
        });
    }
}

