/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase
extends FunctionalTestCase {
    private static final String CLIENT_CIPHER_SUITE_ENABLED = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    private static final String CLIENT_CIPHER_SUITE_DISABLED = "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
    private static final String CLIENT_PROTOCOL_ENABLED = "SSLv3";
    private static final String CLIENT_PROTOCOL_DISABLED = "TLSv1";
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    private String body;

    protected String getConfigFile() {
        return "http-request-restricted-protocols-ciphers-config.xml";
    }

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile(), "UTF-8");
        writer.println("enabledCipherSuites=TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        writer.println("enabledProtocols=SSLv3");
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        String path = ClassUtils.getClassPathRoot(HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.class).getPath();
        return new File(path, String.format("tls-%s.conf", "default"));
    }

    @Test
    public void handshakeSuccessWhenUsingEnabledCipherSpecAndProtocol() throws Exception {
        this.sendRequest(CLIENT_CIPHER_SUITE_DISABLED, CLIENT_PROTOCOL_DISABLED);
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void handshakeFailsWithDisabledCipherSuite() throws Exception {
        this.assertFailure(CLIENT_CIPHER_SUITE_ENABLED, CLIENT_PROTOCOL_DISABLED);
    }

    @Test
    public void handshakeFailsWithDisabledProtocol() throws Exception {
        this.assertFailure(CLIENT_CIPHER_SUITE_DISABLED, CLIENT_PROTOCOL_ENABLED);
    }

    private void assertFailure(String serverCipherSuiteDisabled, String serverProtocolDisabled) throws Exception {
        try {
            this.sendRequest(serverCipherSuiteDisabled, serverProtocolDisabled);
            Assert.fail();
        }
        catch (MessagingException e) {
            Assert.assertTrue((boolean)(e.getCauseException() instanceof IOException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(String serverCipherSuiteDisabled, String serverProtocolDisabled) throws Exception {
        Server server = this.createTlsServer(serverCipherSuiteDisabled, serverProtocolDisabled);
        server.start();
        try {
            this.runFlow("requestFlow", "Test Message");
        }
        finally {
            server.stop();
        }
    }

    private Server createTlsServer(String disabledCipherSuite, String disabledProtocol) throws Exception {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(FileUtils.getResourcePath((String)"serverKeystore", ((Object)((Object)this)).getClass()));
        sslContextFactory.setKeyStorePassword("mulepassword");
        sslContextFactory.setKeyManagerPassword("mulepassword");
        sslContextFactory.addExcludeCipherSuites(new String[]{disabledCipherSuite});
        sslContextFactory.addExcludeProtocols(new String[]{disabledProtocol});
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        connector.setPort(this.httpsPort.getNumber());
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.this.body = IOUtils.toString((InputStream)baseRequest.getInputStream());
                response.setContentType("text/html");
                response.setStatus(200);
                response.getWriter().print("Test Message");
                baseRequest.setHandled(true);
            }
        });
        return server;
    }
}

