/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.ByteArrayInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpRequesterConfigBuilder;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.util.concurrent.Latch;

public class HttpRequestWithMuleClientTestCase
extends FunctionalTestCase {
    public static final String PUT_HTTP_METHOD = "PUT";
    private static final long RESPONSE_TIMEOUT = 100L;
    private static final long SERVER_TIMEOUT = 2000L;
    public static final String TEST_RESPONSE = "test-response";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "http-request-mule-client-config.xml";
    }

    @Test
    public void dispatchRequestUseNewConnectorByDefault() throws MuleException {
        muleContext.getClient().dispatch(this.getUrl(), this.getTestMuleMessage());
        MuleMessage vmMessage = this.getMessageReceivedByFlow();
        Assert.assertThat((Object)vmMessage.getPayload(), (Matcher)Is.is((Object)NullPayload.getInstance().toString()));
    }

    @Ignore(value="See MULE-8049")
    @Test
    public void dispatchHttpPostRequestWithStreamingEnabled() throws Exception {
        muleContext.getClient().dispatch(this.getUrl(), this.getTestMuleMessage(new ByteArrayInputStream("Test Message".getBytes())), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method("POST").build());
        MuleMessage vmMessage = this.getMessageReceivedByFlow();
        Assert.assertThat((Object)vmMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)vmMessage.getPayloadAsString(), (Matcher)Is.is((Object)"Test Message"));
        Assert.assertThat((Object)vmMessage.getInboundProperty("Transfer-Encoding"), (Matcher)Is.is((Object)"chunked"));
    }

    @Test
    public void dispatchWithStreamingDisabled() throws Exception {
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().method(PUT_HTTP_METHOD).requestStreamingMode(HttpStreamingType.NEVER).build();
        muleContext.getClient().dispatch(this.getUrl(), this.getTestMuleMessage("Test Message"), (OperationOptions)options);
        MuleMessage vmMessage = this.getMessageReceivedByFlow();
        Assert.assertThat((Object)vmMessage.getInboundProperty("Transfer-Encoding"), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)vmMessage.getInboundProperty("Content-Length"), (Matcher)Is.is((Object)"12"));
    }

    @Ignore(value="See MULE-8049")
    @Test
    public void sendHttpPutMethod() throws Exception {
        MuleMessage response = muleContext.getClient().send(this.getUrl(), this.getTestMuleMessage("Test Message"), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(PUT_HTTP_METHOD).build());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)"Test Message"));
        MuleMessage vmMessage = this.getMessageReceivedByFlow();
        Assert.assertThat((Object)vmMessage.getPayloadAsString(), (Matcher)Is.is((Object)"Test Message"));
        Assert.assertThat((Object)vmMessage.getInboundProperty("http.method"), (Matcher)Is.is((Object)PUT_HTTP_METHOD));
    }

    @Test
    public void sendDisableRedirect() throws Exception {
        MuleMessage response = muleContext.getClient().send(this.getRedirectUrl(), this.getTestMuleMessage(NullPayload.class), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(PUT_HTTP_METHOD).disableFollowsRedirect().build());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)TEST_RESPONSE));
    }

    @Test
    public void sendEnableRedirect() throws Exception {
        MuleMessage response = muleContext.getClient().send(this.getRedirectUrl(), this.getTestMuleMessage(NullPayload.class), (OperationOptions)HttpRequestOptionsBuilder.newOptions().enableFollowsRedirect().build());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)NullPayload.getInstance().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setWithTimeout() throws Exception {
        this.expectedException.expectCause(IsInstanceOf.instanceOf(TimeoutException.class));
        try {
            muleContext.getClient().send(this.getTimeoutUrl(), this.getTestMuleMessage(NullPayload.class), (OperationOptions)((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().responseTimeout(100L)).build());
        }
        finally {
            LatchMessageProcessor.latch.release();
        }
    }

    @Test
    public void sendDisableRedirectByRequestConfig() throws Exception {
        MuleMessage message = this.getTestMuleMessage(NullPayload.class);
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().method(PUT_HTTP_METHOD).requestConfig(this.getRequestConfig()).build();
        MuleMessage response = muleContext.getClient().send(this.getRedirectUrl(), message, (OperationOptions)options);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)TEST_RESPONSE));
    }

    @Test
    public void disableStatusCodeValidation() throws Exception {
        MuleMessage message = this.getTestMuleMessage(NullPayload.class);
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build();
        MuleMessage response = muleContext.getClient().send(this.getFailureUrl(), message, (OperationOptions)options);
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)500));
    }

    @Test
    public void customRequestConfig() throws Exception {
        MuleMessage message = this.getTestMuleMessage(NullPayload.class);
        HttpRequesterConfig requestConfig = new HttpRequesterConfigBuilder(muleContext).setProtocol(HttpConstants.Protocols.HTTPS).setTlsContext((TlsContextFactory)muleContext.getRegistry().get("tlsContext")).build();
        HttpRequestOptions options = HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().requestConfig(requestConfig).build();
        MuleMessage response = muleContext.getClient().send(String.format("https://localhost:%s/", this.httpsPort.getNumber()), message, (OperationOptions)options);
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)TEST_RESPONSE));
    }

    private MuleMessage getMessageReceivedByFlow() throws MuleException {
        return muleContext.getClient().request("vm://out", 5000L);
    }

    private HttpRequesterConfig getRequestConfig() {
        return (HttpRequesterConfig)muleContext.getRegistry().get("requestConfig");
    }

    private String getUrl() {
        return String.format("http://localhost:%s/path", this.port.getNumber());
    }

    private String getRedirectUrl() {
        return String.format("http://localhost:%s/redirectPath", this.port.getNumber());
    }

    private String getTimeoutUrl() {
        return String.format("http://localhost:%s/timeoutPath", this.port.getNumber());
    }

    private String getFailureUrl() {
        return String.format("http://localhost:%s/failurePath", this.port.getNumber());
    }

    public static class LatchMessageProcessor
    implements MessageProcessor {
        public static Latch latch = new Latch();

        public MuleEvent process(MuleEvent event) throws MuleException {
            try {
                latch.await(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new DefaultMuleException((Throwable)e);
            }
            return event;
        }
    }
}

