/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.security.GeneralSecurityException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestValidateCertificateTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-validate-certificate-config.xml";
    }

    @Override
    protected boolean enableHttps() {
        return true;
    }

    @Test
    public void rejectsMissingCertificate() throws Exception {
        try {
            this.runFlow("missingCertFlow", "Test Message");
            Assert.fail((String)"Failure expected as no valid certificate was provided for client");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)e.getCauseException(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(GeneralSecurityException.class)));
        }
    }

    @Test
    public void acceptsValidCertificate() throws Exception {
        MuleEvent result = this.runFlow("validCertFlow", "Test Message");
        Assert.assertThat((Object)result.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
    }
}

