/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestUriParamsTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-uri-params-config.xml";
    }

    @Test
    public void sendsUriParamsFromList() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("uriParamList");
        MuleEvent event = HttpRequestUriParamsTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setInvocationProperty("paramName", (Object)"testParam2");
        event.getMessage().setInvocationProperty("paramValue", (Object)"testValue2");
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath/testValue1/testValue2"));
    }

    @Test
    public void sendsUriParamsFromMap() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("uriParamMap");
        MuleEvent event = HttpRequestUriParamsTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testParam1", "testValue1");
        params.put("testParam2", "testValue2");
        event.getMessage().setInvocationProperty("params", params);
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath/testValue1/testValue2"));
    }

    @Test
    public void overridesUriParams() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("uriParamOverride");
        MuleEvent event = HttpRequestUriParamsTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testParam1", "testValueNew");
        params.put("testParam2", "testValue2");
        event.getMessage().setInvocationProperty("params", params);
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath/testValueNew/testValue2"));
    }
}

