/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.concurrent.Latch;

public class HttpRequestTimeoutTestCase
extends AbstractHttpRequestTestCase {
    private static int TEST_TIMEOUT = 2000;
    private Latch serverLatch = new Latch();

    protected String getConfigFile() {
        return "http-request-timeout-config.xml";
    }

    @Test
    public void throwsExceptionWhenRequesterTimeoutIsExceeded() throws Exception {
        this.assertTimeout("requestFlow", 1, -1);
    }

    @Test
    public void throwsExceptionWhenEventTimeoutIsExceeded() throws Exception {
        this.assertTimeout("requestFlowNoTimeout", -1, 1);
    }

    @Test
    public void requesterTimeoutOverridesEventTimeout() throws Exception {
        this.assertTimeout("requestFlow", 1, TEST_TIMEOUT * 2);
    }

    private void assertTimeout(final String flowName, final int responseTimeoutRequester, final int responseTimeoutEvent) throws Exception {
        final Latch requestTimeoutLatch = new Latch();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Flow flow = (Flow)HttpRequestTimeoutTestCase.this.getFlowConstruct(flowName);
                    MuleEvent event = AbstractMuleContextTestCase.getTestEvent((Object)"Test Message");
                    event.setTimeout(responseTimeoutEvent);
                    event.setFlowVariable("timeout", (Object)responseTimeoutRequester);
                    try {
                        flow.process(event);
                    }
                    catch (MessagingException e) {
                        Assert.assertThat((Object)e.getCauseException(), (Matcher)CoreMatchers.instanceOf(TimeoutException.class));
                        requestTimeoutLatch.release();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.start();
        Assert.assertTrue((boolean)requestTimeoutLatch.await((long)TEST_TIMEOUT, TimeUnit.MILLISECONDS));
        thread.join();
        this.serverLatch.release();
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.serverLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

