/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

public class HttpRequestSourceTargetTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-source-target-config.xml";
    }

    @Test
    public void requestBodyFromPayloadSource() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("payloadSourceFlow");
        flow.process(HttpRequestSourceTargetTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void requestBodyFromCustomSource() throws Exception {
        this.sendRequestFromCustomSourceAndAssertResponse("Test Message");
    }

    @Test
    public void requestBodyFromCustomSourceAndNullPayload() throws Exception {
        this.sendRequestFromCustomSourceAndAssertResponse(NullPayload.getInstance());
    }

    private void sendRequestFromCustomSourceAndAssertResponse(Object payload) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("customSourceFlow");
        MuleEvent event = HttpRequestSourceTargetTestCase.getTestEvent((Object)payload);
        event.setFlowVariable("customSource", (Object)"customValue");
        flow.process(event);
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)"customValue"));
    }

    @Test
    public void responseBodyToPayloadTarget() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("payloadTargetFlow");
        MuleEvent event = flow.process(HttpRequestSourceTargetTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
    }

    @Test
    public void responseBodyToCustomTarget() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("customTargetFlow");
        MuleEvent event = flow.process(HttpRequestSourceTargetTestCase.getTestEvent((Object)"Test Message"));
        InputStream customTarget = (InputStream)event.getMessage().getOutboundProperty("customTarget");
        Assert.assertThat((Object)customTarget, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)IOUtils.toString((InputStream)customTarget), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }
}

