/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestQueryParamsTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-query-params-config.xml";
    }

    @Test
    public void sendsQueryParamsFromList() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("queryParamList");
        MuleEvent event = HttpRequestQueryParamsTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setInvocationProperty("paramName", (Object)"testName2");
        event.getMessage().setInvocationProperty("paramValue", (Object)"testValue2");
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath?testName1=testValue1&testName2=testValue2"));
    }

    @Test
    public void sendsQueryParamsFromMap() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("queryParamMap");
        MuleEvent event = HttpRequestQueryParamsTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testName1", "testValue1");
        params.put("testName2", "testValue2");
        event.getMessage().setInvocationProperty("params", params);
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath?testName1=testValue1&testName2=testValue2"));
    }

    @Test
    public void queryParamsOverride() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("multipleQueryParam");
        MuleEvent event = HttpRequestQueryParamsTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testName1", "testValueNew");
        params.put("testName2", "testValue2");
        event.getMessage().setInvocationProperty("params", params);
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath?testName1=testValue1&testName1=testValueNew&testName2=testValue2"));
    }
}

