/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import com.ning.http.client.ntlm.NTLMEngine;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.util.NetworkUtils;

@RunWith(value=Parameterized.class)
public class HttpRequestNtlmAuthTestCase
extends AbstractHttpRequestTestCase {
    private static final String TYPE_1_MESSAGE = "NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==";
    private static final String TYPE_2_MESSAGE_CHALLENGE = "TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
    private static final String TYPE_2_MESSAGE = "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
    private static final String USER = "Zaphod";
    private static final String PASSWORD = "Beeblebrox";
    private static final String AUTHORIZED = "Authorized";
    private String type3Message;
    @Parameterized.Parameter(value=0)
    public String flowName;
    @Parameterized.Parameter(value=1)
    public String domain;
    @Parameterized.Parameter(value=2)
    public String workstation;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"ntlmAuthRequestWithDomain", "Ursa-Minor", null}, {"ntlmAuthRequestWithoutDomain", "", null}, {"ntlmAuthRequestWithWorkstation", "Ursa-Minor", "LightCity"});
    }

    @Before
    public void setUp() throws Exception {
        String ntlmHost = this.workstation != null ? this.workstation : NetworkUtils.getLocalHost().getHostName();
        String type3Challenge = NTLMEngine.INSTANCE.generateType3Msg(USER, PASSWORD, this.domain, ntlmHost, TYPE_2_MESSAGE_CHALLENGE);
        this.type3Message = "NTLM " + type3Challenge;
    }

    protected String getConfigFile() {
        return "http-request-ntlm-auth-config.xml";
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            response.setStatus(401);
            response.addHeader("WWW-Authenticate", "NTLM");
        }
        if (TYPE_1_MESSAGE.equals(auth)) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", TYPE_2_MESSAGE);
        } else if (this.type3Message.equals(auth)) {
            response.setStatus(200);
            response.getWriter().print(AUTHORIZED);
        } else {
            response.setStatus(401);
        }
    }

    @Test
    public void validNtlmAuth() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(this.flowName);
        MuleEvent event = HttpRequestNtlmAuthTestCase.getTestEvent((Object)"Test Message");
        event = flow.process(event);
        Assert.assertThat((Object)((Integer)event.getMessage().getInboundProperty("http.status")), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)AUTHORIZED));
    }
}

