/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.module.http.functional.TestConnectorMessageNotificationListener;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestNotificationsTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-notifications-config.xml";
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setNotificationManager(TestConnectorMessageNotificationListener.register(DefaultMuleContextBuilder.createDefaultNotificationManager()));
        super.configureMuleContext(contextBuilder);
    }

    @Test
    public void receiveNotification() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        TestConnectorMessageNotificationListener listener = new TestConnectorMessageNotificationListener(latch, "http://localhost:" + this.httpPort.getValue() + "/basePath/requestPath");
        muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
        this.runFlow("requestFlow", "Test Message");
        latch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertThat(listener.getNotificationActionNames(), (Matcher)Matchers.contains((Object[])new String[]{ServerNotification.getActionName((int)804), ServerNotification.getActionName((int)853)}));
    }
}

