/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.util.StringUtils;

public class HttpRequestKeepAliveTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-keep-alive-config.xml";
    }

    @Test
    public void persistentRequestSendsKeepAliveHeader() throws Exception {
        this.assertConnectionHeader("persistentRequestFlow", null, "keep-alive");
    }

    @Test
    public void nonPersistentRequestSendsCloseHeader() throws Exception {
        this.assertConnectionHeader("nonPersistentRequestFlow", null, "close");
    }

    @Test
    public void persistentRequestWithKeepAlivePropertySendsKeepAliveHeader() throws Exception {
        this.assertConnectionHeader("persistentRequestFlow", "keep-alive", "keep-alive");
    }

    @Test
    public void persistentRequestWithClosePropertySendsCloseHeader() throws Exception {
        this.assertConnectionHeader("persistentRequestFlow", "close", "close");
    }

    @Test
    public void nonPersistentRequestWithKeepAlivePropertySendsCloseHeader() throws Exception {
        this.assertConnectionHeader("nonPersistentRequestFlow", "keep-alive", "close");
    }

    @Test
    public void nonPersistentRequestWithClosePropertySendsCloseHeader() throws Exception {
        this.assertConnectionHeader("nonPersistentRequestFlow", "close", "close");
    }

    private void assertConnectionHeader(String flow, String connectionOutboundProperty, String expectedConnectionHeader) throws Exception {
        MuleEvent event = HttpRequestKeepAliveTestCase.getTestEvent((Object)"Test Message");
        if (connectionOutboundProperty != null) {
            event.getMessage().setOutboundProperty("Connection", (Object)connectionOutboundProperty);
        }
        this.runFlow(flow, event);
        String responseConnectionHeaderValue = StringUtils.join((Collection)this.headers.get((Object)"Connection"), (String)" ");
        Assert.assertThat((Object)responseConnectionHeaderValue, (Matcher)CoreMatchers.equalTo((Object)expectedConnectionHeader));
    }
}

