/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;

public class HttpRequestFunctionalTestCase
extends AbstractHttpRequestTestCase {
    private static final String TEST_HEADER_NAME = "TestHeaderName";
    private static final String TEST_HEADER_VALUE = "TestHeaderValue";
    private static final String DEFAULT_PORT_HTTP_REQUEST_CONFIG_NAME = "requestConfigHttp";
    private static final String DEFAULT_PORT_HTTPS_REQUEST_CONFIG_NAME = "requestConfigHttps";

    protected String getConfigFile() {
        return "http-request-functional-config.xml";
    }

    @Test
    public void requestConfigDefaultPortHttp() {
        HttpRequesterConfig httpRequesterConfig = (HttpRequesterConfig)muleContext.getRegistry().get(DEFAULT_PORT_HTTP_REQUEST_CONFIG_NAME);
        Assert.assertThat((Object)httpRequesterConfig.getPort(), (Matcher)Is.is((Object)String.valueOf(HttpConstants.Protocols.HTTP.getDefaultPort())));
    }

    @Test
    public void requestConfigDefaultPortHttps() {
        HttpRequesterConfig httpRequesterConfig = (HttpRequesterConfig)muleContext.getRegistry().get(DEFAULT_PORT_HTTPS_REQUEST_CONFIG_NAME);
        Assert.assertThat((Object)httpRequesterConfig.getPort(), (Matcher)Is.is((Object)String.valueOf(HttpConstants.Protocols.HTTPS.getDefaultPort())));
    }

    @Test
    public void requestConfigDefaultTlsContextHttps() {
        DefaultHttpRequesterConfig httpRequesterConfig = (DefaultHttpRequesterConfig)muleContext.getRegistry().get(DEFAULT_PORT_HTTPS_REQUEST_CONFIG_NAME);
        Assert.assertThat((Object)httpRequesterConfig.getTlsContext(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void payloadIsSentAsRequestBody() throws Exception {
        this.runFlow("requestFlow", "Test Message");
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void outboundPropertiesAreSentAsHeaders() throws Exception {
        MuleEvent event = HttpRequestFunctionalTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("TestHeader", (Object)"TestValue");
        this.testFlow("requestFlow", event);
        Assert.assertThat((Object)this.getFirstReceivedHeader("TestHeader"), (Matcher)CoreMatchers.equalTo((Object)"TestValue"));
    }

    @Test
    public void responseBodyIsMappedToPayload() throws Exception {
        MuleEvent event = this.runFlow("requestFlow", "Test Message");
        Assert.assertTrue((boolean)(event.getMessage().getPayload() instanceof InputStream));
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
    }

    @Test
    public void responseStatusCodeIsSetAsInboundProperty() throws Exception {
        MuleEvent event = this.runFlow("requestFlow", "Test Message");
        Assert.assertThat((Object)((Integer)event.getMessage().getInboundProperty("http.status")), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void responseHeadersAreMappedAsInboundProperties() throws Exception {
        MuleEvent event = this.runFlow("requestFlow", "Test Message");
        String headerValue = (String)event.getMessage().getInboundProperty(TEST_HEADER_NAME);
        Assert.assertThat((Object)headerValue, (Matcher)CoreMatchers.equalTo((Object)TEST_HEADER_VALUE));
    }

    @Test
    public void basePathFromConfigIsUsedInRequest() throws Exception {
        this.runFlow("requestFlow", "Test Message");
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/basePath/requestPath"));
    }

    @Test
    public void previousInboundPropertiesAreCleared() throws Exception {
        MuleEvent event = HttpRequestFunctionalTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setProperty("TestInboundProperty", (Object)"TestValue", PropertyScope.INBOUND);
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        event = flow.process(event);
        Assert.assertThat((Object)event.getMessage().getInboundProperty("TestInboundProperty"), (Matcher)IsNull.nullValue());
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.addHeader(TEST_HEADER_NAME, TEST_HEADER_VALUE);
        super.handleRequest(baseRequest, request, response);
    }
}

