/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

@RunWith(value=Parameterized.class)
public class HttpRequestEncodingTestCase
extends AbstractHttpRequestTestCase {
    private static final String JAPANESE_MESSAGE = "\u3042";
    private static final String ARABIC_MESSAGE = "\u0634";
    private static final String CYRILLIC_MESSAGE = "\u0416";
    private static final String SIMPLE_MESSAGE = "A";
    @Parameterized.Parameter(value=0)
    public String encoding;
    @Parameterized.Parameter(value=1)
    public String testMessage;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"EUC-JP", JAPANESE_MESSAGE}, {"Windows-31J", JAPANESE_MESSAGE}, {"ISO-2022-JP", JAPANESE_MESSAGE}, {"UTF-8", JAPANESE_MESSAGE}, {"Arabic", ARABIC_MESSAGE}, {"Windows-1256", ARABIC_MESSAGE}, {"Windows-1251", CYRILLIC_MESSAGE}, {"Cyrillic", CYRILLIC_MESSAGE}, {"US-ASCII", SIMPLE_MESSAGE});
    }

    protected String getConfigFile() {
        return "http-request-encoding-config.xml";
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", String.format("text/plain; charset=%s", this.encoding));
        response.setStatus(200);
        response.getWriter().print(this.testMessage);
    }

    @Test
    public void testEncoding() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("encodingTest");
        MuleEvent result = flow.process(HttpRequestEncodingTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)result.getMessage().getPayloadAsString(), (Matcher)Matchers.is((Object)this.testMessage));
    }
}

