/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.security.Constraint;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.util.FileUtils;

public class HttpRequestAuthTestCase
extends AbstractHttpRequestTestCase {
    private int requestCount = 0;

    protected String getConfigFile() {
        return "http-request-auth-config.xml";
    }

    @Test
    public void validBasicNonPreemptiveAuthentication() throws Exception {
        this.assertValidRequest("basicAuthRequest", "user", "password", false);
        Assert.assertThat((Object)this.requestCount, (Matcher)Is.is((Object)2));
    }

    @Test
    public void validBasicPreemptiveAuthentication() throws Exception {
        this.assertValidRequest("basicAuthRequest", "user", "password", true);
        Assert.assertThat((Object)this.requestCount, (Matcher)Is.is((Object)1));
    }

    @Test
    public void validDigestAuth() throws Exception {
        this.assertValidRequest("digestAuthRequest", "user", "password", false);
    }

    private void assertValidRequest(String flowName, String user, String password, boolean preemptive) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent event = HttpRequestAuthTestCase.getTestEvent((Object)"Test Message");
        event.setFlowVariable("user", (Object)user);
        event.setFlowVariable("password", (Object)password);
        event.setFlowVariable("preemptive", (Object)preemptive);
        event = flow.process(event);
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
    }

    @Override
    protected AbstractHandler createHandler(Server server) {
        AbstractHandler handler = super.createHandler(server);
        String realmPath = null;
        try {
            realmPath = FileUtils.getResourcePath((String)"realm.properties", ((Object)((Object)this)).getClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashLoginService loginService = new HashLoginService("TestRealm", realmPath);
        server.addBean((Object)loginService);
        Constraint basicConstraint = new Constraint();
        basicConstraint.setName("auth");
        basicConstraint.setRoles(new String[]{"user"});
        basicConstraint.setAuthenticate(true);
        ConstraintMapping basicConstraintMapping = new ConstraintMapping();
        basicConstraintMapping.setConstraint(basicConstraint);
        basicConstraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler basicSecurityHandler = new ConstraintSecurityHandler(){

            public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                HttpRequestAuthTestCase.this.requestCount++;
                super.handle(pathInContext, baseRequest, request, response);
            }
        };
        basicSecurityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        basicSecurityHandler.setConstraintMappings(new ConstraintMapping[]{basicConstraintMapping});
        ContextHandler basicContext = new ContextHandler("/basic");
        basicContext.setHandler((Handler)basicSecurityHandler);
        Constraint digestConstraint = new Constraint();
        digestConstraint.setName("auth");
        digestConstraint.setRoles(new String[]{"user"});
        digestConstraint.setAuthenticate(true);
        ConstraintMapping digestConstraintMapping = new ConstraintMapping();
        digestConstraintMapping.setConstraint(digestConstraint);
        digestConstraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler digestSecurityHandler = new ConstraintSecurityHandler();
        digestSecurityHandler.setAuthenticator((Authenticator)new DigestAuthenticator());
        digestSecurityHandler.setConstraintMappings(new ConstraintMapping[]{digestConstraintMapping});
        ContextHandler digestContext = new ContextHandler("/digest");
        digestContext.setHandler((Handler)digestSecurityHandler);
        basicSecurityHandler.setHandler((Handler)handler);
        digestSecurityHandler.setHandler((Handler)handler);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{basicContext, digestContext});
        return handlers;
    }
}

