/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.proxy;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.config.spring.util.ProcessingStrategyUtils;
import org.mule.module.http.functional.TestInputStream;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.tck.SensingNullRequestResponseMessageProcessor;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;
import org.mule.util.concurrent.Latch;

@RunWith(value=Parameterized.class)
public class HttpProxyTemplateTestCase
extends AbstractHttpRequestTestCase {
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public SystemProperty systemProperty;
    private static String SENSING_REQUEST_RESPONSE_PROCESSOR_NAME = "sensingRequestResponseProcessor";
    private RequestHandlerExtender handlerExtender;
    private boolean consumeAllRequest = true;
    private String configFile;
    private String requestThreadNameSubString;
    private String responeThreadNameSubString;
    private boolean nonBlocking;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"http-proxy-template-config.xml", "worker", "worker", false}, {"http-proxy-template-config.xml", "worker", "proxyTemplate", true});
    }

    public HttpProxyTemplateTestCase(String configFile, String requestThreadNameSubString, String responeThreadNameSubString, boolean nonBlocking) {
        this.configFile = configFile;
        this.requestThreadNameSubString = requestThreadNameSubString;
        this.responeThreadNameSubString = responeThreadNameSubString;
        this.nonBlocking = nonBlocking;
        if (nonBlocking) {
            this.systemProperty = new SystemProperty("mule.default.processing.strategy", ProcessingStrategyUtils.NON_BLOCKING_PROCESSING_STRATEGY);
        }
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void proxySimpleRequests() throws Exception {
        this.handlerExtender = null;
        this.assertRequestOk(this.getProxyUrl(""), null);
        this.assertRequestOk(this.getProxyUrl("test"), null);
    }

    @Test
    public void failIfTargetServiceIsDown() throws Exception {
        this.handlerExtender = null;
        this.stopServer();
        Response response = Request.Get((String)this.getProxyUrl("")).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)500));
    }

    @Test
    public void proxyMethod() throws Exception {
        this.handlerExtender = new EchoRequestHandlerExtender(){

            @Override
            protected String selectRequestPartToReturn(org.eclipse.jetty.server.Request baseRequest) {
                return baseRequest.getMethod();
            }
        };
        this.assertRequestOk(this.getProxyUrl("test?parameterName=parameterValue"), "GET");
        Response response = Request.Post((String)this.getProxyUrl("test?parameterName=parameterValue")).bodyString("Some Text", ContentType.DEFAULT_TEXT).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)"POST"));
    }

    @Ignore
    @Test
    public void proxyProtocolHttp1_0() throws Exception {
        this.handlerExtender = new EchoRequestHandlerExtender(){

            @Override
            protected String selectRequestPartToReturn(org.eclipse.jetty.server.Request baseRequest) {
                return baseRequest.getProtocol();
            }
        };
        Response response = Request.Get((String)this.getProxyUrl("test?parameterName=parameterValue")).version(HttpVersion.HTTP_1_0).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)"HTTP/1.0"));
    }

    @Test
    public void proxyProtocolHttp1_1() throws Exception {
        this.handlerExtender = new EchoRequestHandlerExtender(){

            @Override
            protected String selectRequestPartToReturn(org.eclipse.jetty.server.Request baseRequest) {
                return baseRequest.getProtocol();
            }
        };
        this.assertRequestOk(this.getProxyUrl("test?parameterName=parameterValue"), "HTTP/1.1");
    }

    @Test
    public void proxyStreaming() throws Exception {
        final Latch latch = new Latch();
        this.consumeAllRequest = false;
        this.handlerExtender = new RequestHandlerExtender(){

            @Override
            public void handleRequest(org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                HttpProxyTemplateTestCase.this.extractHeadersFromBaseRequest(baseRequest);
                latch.release();
                IOUtils.toString((InputStream)baseRequest.getInputStream());
                response.setContentType(request.getContentType());
                response.setStatus(200);
                response.getWriter().print("OK");
            }
        };
        AsyncHttpClientConfig.Builder configBuilder = new AsyncHttpClientConfig.Builder();
        AsyncHttpClientConfig config = configBuilder.build();
        AsyncHttpClient asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder = asyncHttpClient.preparePost(this.getProxyUrl("test?parameterName=parameterValue"));
        boundRequestBuilder.setBody((BodyGenerator)new InputStreamBodyGenerator((InputStream)new TestInputStream(latch)));
        ListenableFuture future = boundRequestBuilder.execute();
        com.ning.http.client.Response response = (com.ning.http.client.Response)future.get();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        response.getHeaders();
        Assert.assertThat((Object)this.getFirstReceivedHeader("Transfer-Encoding"), (Matcher)Matchers.is((Object)"chunked"));
        Assert.assertThat((Object)response.getResponseBody(), (Matcher)Matchers.is((Object)"OK"));
        asyncHttpClient.close();
    }

    @Test
    public void proxyPath() throws Exception {
        this.handlerExtender = new EchoRequestHandlerExtender(){

            @Override
            protected String selectRequestPartToReturn(org.eclipse.jetty.server.Request baseRequest) {
                return baseRequest.getPathInfo();
            }
        };
        this.assertRequestOk(this.getProxyUrl("test?parameterName=parameterValue"), "/test");
    }

    @Test
    public void proxyQueryString() throws Exception {
        this.handlerExtender = new EchoRequestHandlerExtender(){

            @Override
            protected String selectRequestPartToReturn(org.eclipse.jetty.server.Request baseRequest) {
                return baseRequest.getQueryString();
            }
        };
        this.assertRequestOk(this.getProxyUrl("test?parameterName=parameterValue"), "parameterName=parameterValue");
    }

    @Test
    public void proxyBody() throws Exception {
        this.handlerExtender = new EchoRequestHandlerExtender(){

            @Override
            protected String selectRequestPartToReturn(org.eclipse.jetty.server.Request baseRequest) {
                return HttpProxyTemplateTestCase.this.body;
            }
        };
        Response response = Request.Post((String)this.getProxyUrl("test")).bodyString("Some Text", ContentType.DEFAULT_TEXT).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)"Some Text"));
    }

    @Test
    public void proxyHeaders() throws Exception {
        this.handlerExtender = null;
        Response response = Request.Get((String)this.getProxyUrl("/test?name=value")).addHeader("MyCustomHeaderName", "MyCustomHeaderValue").connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)this.getFirstReceivedHeader("MyCustomHeaderName"), (Matcher)Matchers.is((Object)"MyCustomHeaderValue"));
        HashSet<String> lowerCaseHeaderNames = new HashSet<String>();
        for (Header header : httpResponse.getAllHeaders()) {
            lowerCaseHeaderNames.add(header.getName().toLowerCase());
            Assert.assertThat((Object)header.getName(), (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)"http.")));
        }
        Assert.assertThat((Object)lowerCaseHeaderNames.size(), (Matcher)Matchers.is((Object)httpResponse.getAllHeaders().length));
    }

    @Test
    public void setXForwardedForHeader() throws Exception {
        this.handlerExtender = null;
        Response response = Request.Get((String)this.getProxyUrl("")).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)this.getFirstReceivedHeader("X-Forwarded-For"), (Matcher)Matchers.startsWith((String)"/127.0.0.1:"));
    }

    @Test
    public void requestThread() throws Exception {
        Request.Get((String)this.getProxyUrl("")).connectTimeout(5000).execute();
        SensingNullRequestResponseMessageProcessor sensingMessageProcessor = this.getSensingNullRequestResponseMessageProcessor();
        Assert.assertThat((Object)sensingMessageProcessor.requestThread.getName(), (Matcher)CoreMatchers.containsString((String)this.requestThreadNameSubString));
    }

    @Test
    public void responseThread() throws Exception {
        this.assertRequestOk(this.getProxyUrl(""), null);
        SensingNullRequestResponseMessageProcessor requestResponseProcessor = this.getSensingNullRequestResponseMessageProcessor();
        if (this.nonBlocking) {
            Assert.assertThat((Object)requestResponseProcessor.requestThread, (Matcher)Matchers.not((Matcher)CoreMatchers.equalTo((Object)requestResponseProcessor.responseThread)));
            Assert.assertThat((Object)requestResponseProcessor.responseThread.getName(), (Matcher)CoreMatchers.containsString((String)this.responeThreadNameSubString));
        } else {
            Assert.assertThat((Object)requestResponseProcessor.requestThread, (Matcher)CoreMatchers.equalTo((Object)requestResponseProcessor.responseThread));
        }
    }

    private SensingNullRequestResponseMessageProcessor getSensingNullRequestResponseMessageProcessor() {
        return (SensingNullRequestResponseMessageProcessor)muleContext.getRegistry().lookupObject(SENSING_REQUEST_RESPONSE_PROCESSOR_NAME);
    }

    private void assertRequestOk(String url, String expectedResponse) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        if (expectedResponse != null) {
            Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Matchers.is((Object)expectedResponse));
        }
    }

    private String getProxyUrl(String path) {
        return String.format("http://localhost:%s/%s", this.proxyPort.getNumber(), path);
    }

    private String getServerUrl(String path) {
        return String.format("http://localhost:%s/%s", this.httpPort.getNumber(), path);
    }

    @Override
    protected void handleRequest(org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.consumeAllRequest) {
            this.extractBaseRequestParts(baseRequest);
        }
        if (this.handlerExtender == null) {
            this.writeResponse(response);
        } else {
            this.handlerExtender.handleRequest(baseRequest, request, response);
        }
    }

    private static abstract class EchoRequestHandlerExtender
    implements RequestHandlerExtender {
        private EchoRequestHandlerExtender() {
        }

        @Override
        public void handleRequest(org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType(request.getContentType());
            response.setStatus(200);
            response.getWriter().print(this.selectRequestPartToReturn(baseRequest));
        }

        protected abstract String selectRequestPartToReturn(org.eclipse.jetty.server.Request var1);
    }

    private static interface RequestHandlerExtender {
        public void handleRequest(org.eclipse.jetty.server.Request var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;
    }
}

