/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.proxy;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.config.spring.util.ProcessingStrategyUtils;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class HttpProxyTemplateErrorHandlingTestCase
extends AbstractHttpRequestTestCase {
    public static String SERVICE_DOWN_MESSAGE = "Service Down";
    public static String CATCH_SENSING_PROCESSOR_NAME = "catchSensingMessageProcessor";
    public static String ROLLBACK_SENSING_PROCESSOR_NAME = "rollbackSensingMessageProcessor";
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public SystemProperty systemProperty;
    private String configFile;
    private boolean nonBlocking;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"http-proxy-template-error-handling-config.xml", false}, {"http-proxy-template-error-handling-config.xml", true});
    }

    public HttpProxyTemplateErrorHandlingTestCase(String configFile, boolean nonBlocking) {
        this.configFile = configFile;
        this.nonBlocking = nonBlocking;
        if (nonBlocking) {
            this.systemProperty = new SystemProperty("mule.default.processing.strategy", ProcessingStrategyUtils.NON_BLOCKING_PROCESSING_STRATEGY);
        }
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Override
    @Before
    public void startServer() throws Exception {
    }

    @Override
    @After
    public void stopServer() throws Exception {
    }

    @Test
    public void noExceptionStrategy() throws Exception {
        HttpResponse response = Request.Get((String)this.getProxyUrl("noExceptionStrategy")).connectTimeout(5000).execute().returnResponse();
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)500));
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        HttpResponse response = Request.Get((String)this.getProxyUrl("catchExceptionStrategy")).connectTimeout(5000).execute().returnResponse();
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.equalTo((Object)SERVICE_DOWN_MESSAGE));
        SensingNullMessageProcessor processor = (SensingNullMessageProcessor)muleContext.getRegistry().lookupObject(CATCH_SENSING_PROCESSOR_NAME);
        Assert.assertThat((Object)processor.event, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void rollbackExceptionStrategy() throws Exception {
        HttpResponse response = Request.Get((String)this.getProxyUrl("rollbackExceptionStrategy")).connectTimeout(5000).execute().returnResponse();
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)500));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)SERVICE_DOWN_MESSAGE)));
        SensingNullMessageProcessor processor = (SensingNullMessageProcessor)muleContext.getRegistry().lookupObject(ROLLBACK_SENSING_PROCESSOR_NAME);
        Assert.assertThat((Object)processor.event, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private String getProxyUrl(String path) {
        return String.format("http://localhost:%s/%s", this.proxyPort.getNumber(), path);
    }
}

