/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.proxy;

import java.io.IOException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.functional.AbstractHttpExpectHeaderServerTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpProxyExpectHeaderTestCase
extends AbstractHttpExpectHeaderServerTestCase {
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");

    protected String getConfigFile() {
        return "http-proxy-template-config.xml";
    }

    @Test
    public void handlesContinueResponse() throws Exception {
        this.startExpectContinueServer();
        Response response = this.sendRequest();
        Assert.assertThat((Object)response.returnContent().asString(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        this.stopServer();
    }

    @Test
    public void handlesExpectationFailedResponse() throws Exception {
        this.startExpectFailedServer();
        Response response = this.sendRequest();
        Assert.assertThat((Object)response.returnResponse().getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        this.stopServer();
    }

    private Response sendRequest() throws IOException {
        return Request.Post((String)String.format("http://localhost:%s", this.proxyPort.getNumber())).useExpectContinue().bodyString("Test Message", ContentType.DEFAULT_TEXT).connectTimeout(5000).execute();
    }
}

