/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.matcher.ParamMapMatcher;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.transport.NullPayload;

public class HttpListenerUrlEncodedTestCase
extends FunctionalTestCase {
    public static final String PARAM_1_NAME = "param1";
    public static final String PARAM_2_NAME = "param2";
    public static final String PARAM_1_VALUE = "param1Value";
    public static final String PARAM_2_VALUE = "param2Value";
    public static final String PARAM_2_VALUE_1 = "param2Value1";
    public static final String PARAM_2_VALUE_2 = "param2Value2";
    public static final String VM_OUTPUT_ENDPOINT = "vm://out";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");

    protected String getConfigFile() {
        return "http-listener-url-encoded-config.xml";
    }

    @Test
    public void urlEncodedParamsGenerateAMapPayload() throws Exception {
        Response response = Request.Post((String)this.getListenerUrl()).bodyForm(new NameValuePair[]{new BasicNameValuePair(PARAM_1_NAME, PARAM_1_VALUE), new BasicNameValuePair(PARAM_2_NAME, PARAM_2_VALUE)}).execute();
        MuleMessage receivedMessage = muleContext.getClient().request(VM_OUTPUT_ENDPOINT, 1000L);
        Assert.assertThat((Object)receivedMessage.getPayload(), (Matcher)IsInstanceOf.instanceOf(ParameterMap.class));
        ParameterMap payloadAsMap = (ParameterMap)receivedMessage.getPayload();
        Assert.assertThat((Object)payloadAsMap.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)payloadAsMap.get((Object)PARAM_1_NAME), (Matcher)Is.is((Object)PARAM_1_VALUE));
        Assert.assertThat((Object)payloadAsMap.get((Object)PARAM_2_NAME), (Matcher)Is.is((Object)PARAM_2_VALUE));
        this.compareParameterMaps(response, payloadAsMap);
    }

    @Test
    public void invalidUrlEncodedParamsReturnInvalidRequestStatusCode() throws Exception {
        Response response = Request.Post((String)this.getListenerUrl()).body((HttpEntity)new StringEntity("Invalid url encoded content")).addHeader("Content-Type", "application/x-www-form-urlencoded").execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)URLDecoder.decode(IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), Charsets.UTF_8.name()), (Matcher)Is.is((Object)"Invalid url encoded content"));
    }

    @Test
    public void urlEncodedMultiValueParamsHasOldValues() throws Exception {
        Response response = Request.Post((String)this.getListenerUrl()).bodyForm(new NameValuePair[]{new BasicNameValuePair(PARAM_1_NAME, PARAM_1_VALUE), new BasicNameValuePair(PARAM_2_NAME, PARAM_2_VALUE_1), new BasicNameValuePair(PARAM_2_NAME, PARAM_2_VALUE_2)}).execute();
        MuleMessage receivedMessage = muleContext.getClient().request(VM_OUTPUT_ENDPOINT, 1000L);
        Assert.assertThat((Object)receivedMessage.getPayload(), (Matcher)IsInstanceOf.instanceOf(ParameterMap.class));
        ParameterMap payloadAsMap = (ParameterMap)receivedMessage.getPayload();
        Assert.assertThat((Object)payloadAsMap.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)payloadAsMap.get((Object)PARAM_1_NAME), (Matcher)Is.is((Object)PARAM_1_VALUE));
        Assert.assertThat((Object)payloadAsMap.getAll(PARAM_2_NAME).size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(payloadAsMap.getAll(PARAM_2_NAME).get(0), (Matcher)Is.is((Object)PARAM_2_VALUE_1));
        Assert.assertThat(payloadAsMap.getAll(PARAM_2_NAME).get(1), (Matcher)Is.is((Object)PARAM_2_VALUE_2));
        this.compareParameterMaps(response, payloadAsMap);
    }

    @Test
    public void urlEncodedEmptyParamsGenerateANullPayload() throws Exception {
        Response response = Request.Post((String)this.getListenerUrl()).execute();
        this.assertNullPayloadAndEmptyResponse(response);
    }

    @Test
    public void urlEncodedEmptyParamsUrlEncodedContentTypeGenerateANullPayload() throws Exception {
        Response response = Request.Post((String)this.getListenerUrl()).addHeader("Content-Type", "application/x-www-form-urlencoded").execute();
        this.assertNullPayloadAndEmptyResponse(response);
    }

    private void assertNullPayloadAndEmptyResponse(Response response) throws Exception {
        MuleMessage receivedMessage = muleContext.getClient().request(VM_OUTPUT_ENDPOINT, 1000L);
        Assert.assertThat((Object)receivedMessage.getPayload(), (Matcher)IsInstanceOf.instanceOf(NullPayload.class));
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getFirstHeader("Content-Length").getValue(), (Matcher)Is.is((Object)"0"));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)""));
    }

    private void compareParameterMaps(Response response, ParameterMap payloadAsMap) throws IOException {
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getFirstHeader("Content-Type").getValue(), (Matcher)Is.is((Object)"application/x-www-form-urlencoded"));
        String responseContent = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
        Assert.assertThat((Object)payloadAsMap, ParamMapMatcher.isEqual(HttpParser.decodeUrlEncodedBody((String)responseContent, (String)Charsets.UTF_8.name()).toListValuesMap()));
    }

    private String getListenerUrl() {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), this.path.getValue());
    }
}

