/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import org.apache.http.HttpEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.StringEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpListenerSocketConfigTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "http-listener-socket-config.xml";
    }

    @Test
    public void globalServerSocketProperties() throws Exception {
        this.assertResponse(this.listenPort1.getNumber(), "global");
    }

    private void assertResponse(int port, String path) throws Exception {
        String url = String.format("http://localhost:%s/%s", port, path);
        Response response = Request.Post((String)url).body((HttpEntity)new StringEntity("Test Message")).connectTimeout(1000).execute();
        Assert.assertThat((Object)response.returnContent().asString(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }
}

