/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class HttpListenerResponseStreamingTestCase
extends FunctionalTestCase {
    public static final String TEST_BODY = RandomStringUtils.randomAlphabetic((int)102400);
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "http-listener-response-streaming-config.xml";
    }

    @Test
    public void string() throws Exception {
        String url = this.getUrl("string");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void stringWithContentLengthHeader() throws Exception {
        String url = this.getUrl("stringWithContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void stringWithContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("stringWithContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void stringWithTransferEncoding() throws Exception {
        String url = this.getUrl("stringWithTransferEncoding");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void stringWithTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingOutboundProperty");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void inputStream() throws Exception {
        String url = this.getUrl("inputStream");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void inputStreamWithContentLengthHeader() throws Exception {
        String url = this.getUrl("inputStreamWithContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void inputStreamWithContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("inputStreamWithContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void inputStreamWithTransferEncoding() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncoding");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void inputStreamWithTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingOutboundProperty");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void inputStreamWithTransferEncodingAndContentLength() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingAndContentLength");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void neverString() throws Exception {
        String url = this.getUrl("neverString");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void neverStringTransferEncodingHeader() throws Exception {
        String url = this.getUrl("neverStringTransferEncodingHeader");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void neverStringTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("neverStringTransferEncodingOutboundProperty");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void neverInputStream() throws Exception {
        String url = this.getUrl("neverInputStream");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void neverInputStreamTransferEncodingHeader() throws Exception {
        String url = this.getUrl("neverInputStreamTransferEncodingHeader");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void neverInputStreamTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("neverInputStreamTransferEncodingOutboundProperty");
        this.testResponseIsContentLengthEncoding(url);
    }

    @Test
    public void alwaysString() throws Exception {
        String url = this.getUrl("alwaysString");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void alwaysStringContentLengthHeader() throws Exception {
        String url = this.getUrl("alwaysStringContentLengthHeader");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void alwaysStringContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("alwaysStringContentLengthOutboundProperty");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void alwaysInputStream() throws Exception {
        String url = this.getUrl("alwaysInputStream");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void alwaysInputStreamContentLengthHeader() throws Exception {
        String url = this.getUrl("alwaysInputStreamContentLengthHeader");
        this.testResponseIsChunkedEncoding(url);
    }

    @Test
    public void alwaysInputStreamContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("alwaysInputStreamContentLengthOutboundProperty");
        this.testResponseIsChunkedEncoding(url);
    }

    private void testResponseIsContentLengthEncoding(String url) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).socketTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header transferEncodingHeader = httpResponse.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = httpResponse.getFirstHeader("Content-Length");
        Assert.assertThat((Object)contentLengthHeader, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)transferEncodingHeader, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)TEST_BODY));
    }

    private String getUrl(String path) {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), path);
    }

    private void testResponseIsChunkedEncoding(String url) throws IOException {
        Response response = Request.Post((String)url).connectTimeout(1000).socketTimeout(1000).bodyByteArray(TEST_BODY.getBytes()).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header transferEncodingHeader = httpResponse.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = httpResponse.getFirstHeader("Content-Length");
        Assert.assertThat((Object)contentLengthHeader, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)transferEncodingHeader, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)transferEncodingHeader.getValue(), (Matcher)CoreMatchers.is((Object)"chunked"));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)TEST_BODY));
    }
}

