/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.ByteArrayInputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpListenerRequestStreamingTestCase
extends FunctionalTestCase {
    private static final String LARGE_MESSAGE = RandomStringUtils.randomAlphanumeric((int)102400);
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    private String flowReceivedMessage;

    protected String getConfigFile() {
        return "http-listener-request-streaming-config.xml";
    }

    @Test
    public void listenerReceivedChunkedRequest() throws Exception {
        String url = String.format("http://localhost:%s/", this.listenPort.getNumber());
        this.getFunctionalTestComponent("defaultFlow").setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                HttpListenerRequestStreamingTestCase.this.flowReceivedMessage = context.getMessageAsString();
            }
        });
        this.testChunkedRequestContentAndResponse(url);
        this.testChunkedRequestContentAndResponse(url);
    }

    private void testChunkedRequestContentAndResponse(String url) throws Exception {
        HttpRequestOptions requestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build();
        muleContext.getClient().send(url, this.getTestMuleMessage(new ByteArrayInputStream(LARGE_MESSAGE.getBytes())), (OperationOptions)requestOptions);
        Assert.assertThat((Object)this.flowReceivedMessage, (Matcher)Is.is((Object)LARGE_MESSAGE));
    }
}

