/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.StringUtils;

public class HttpListenerPersistentConnectionsTestCase
extends FunctionalTestCase {
    private static final int HTTP_OK = 200;
    private static final int GET_TIMEOUT = 1000;
    private static final String HEADER_CONNECTION_NAME = "Connection";
    public static final String HEADER_CONNECTION_CLOSE_VALUE = "close";
    @Rule
    public DynamicPort nonPersistentPort = new DynamicPort("nonPersistentPort");
    @Rule
    public DynamicPort persistentPort = new DynamicPort("persistentPort");

    protected String getConfigFile() {
        return "http-listener-persistent-connections-config.xml";
    }

    @Test
    public void nonPersistentCheckHeader() throws Exception {
        Assert.assertThat((Object)this.performRequest(this.nonPersistentPort.getNumber()), (Matcher)Matchers.is((Object)HEADER_CONNECTION_CLOSE_VALUE));
    }

    @Test
    public void persistentCheckHeader() throws Exception {
        Assert.assertThat((Object)this.performRequest(this.persistentPort.getNumber()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void nonPersistentConnectionClosing() throws Exception {
        Socket socket = new Socket("localhost", this.nonPersistentPort.getNumber());
        this.sendRequest(socket);
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket);
        this.assertResponse(this.getResponse(socket), false);
        socket.close();
    }

    @Test
    public void persistentConnectionClosing() throws Exception {
        Socket socket = new Socket("localhost", this.persistentPort.getNumber());
        this.sendRequest(socket);
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket);
        this.assertResponse(this.getResponse(socket), true);
        Thread.sleep(3000L);
        this.sendRequest(socket);
        this.assertResponse(this.getResponse(socket), false);
        socket.close();
    }

    private String performRequest(int port) throws IOException {
        String url = String.format("http://localhost:%s/", port);
        HttpResponse response = Request.Get((String)url).connectTimeout(1000).execute().returnResponse();
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Header connectionHeader = response.getFirstHeader(HEADER_CONNECTION_NAME);
        return connectionHeader != null ? connectionHeader.getValue() : null;
    }

    private void assertResponse(String response, boolean shouldBeValid) {
        Assert.assertThat((Object)StringUtils.isEmpty((String)response), (Matcher)Matchers.is((Object)(!shouldBeValid ? 1 : 0)));
    }

    private void sendRequest(Socket socket) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET / HTTP/1.1");
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    private String getResponse(Socket socket) {
        try {
            StringWriter writer = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (reader != null) {
                String line;
                while (!StringUtils.isEmpty((String)(line = reader.readLine()))) {
                    writer.append(line).append("\r\n");
                }
            }
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

