/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.construct.Flow;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.module.http.api.listener.HttpListenerConfig;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class HttpListenerLifecycleTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "http-listener-lifecycle-config.xml";
    }

    @Test
    public void stoppedListenerReturns503() throws Exception {
        HttpListener httpListener = (HttpListener)((Flow)this.getFlowConstruct("testPathFlow")).getMessageSource();
        httpListener.stop();
        Response response = Request.Get((String)this.getLifecycleConfigUrl("/path/subpath")).execute();
        Assert.assertThat((Object)response.returnResponse().getStatusLine().getStatusCode(), (Matcher)Is.is((Object)503));
    }

    @Test
    public void stopOneListenerDoesNotAffectAnother() throws Exception {
        HttpListener httpListener = (HttpListener)((Flow)this.getFlowConstruct("testPathFlow")).getMessageSource();
        httpListener.stop();
        this.callAndAssertResponseFromUnaffectedListener();
    }

    @Test
    public void restartListener() throws Exception {
        HttpListener httpListener = (HttpListener)((Flow)this.getFlowConstruct("testPathFlow")).getMessageSource();
        httpListener.stop();
        httpListener.start();
        Response response = Request.Get((String)this.getLifecycleConfigUrl("/path/subpath")).execute();
        HttpResponse httoResponse = response.returnResponse();
        Assert.assertThat((Object)httoResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httoResponse.getEntity().getContent()), (Matcher)Is.is((Object)"ok"));
    }

    @Test
    public void disposeListenerReturns404() throws Exception {
        HttpListener httpListener = (HttpListener)((Flow)this.getFlowConstruct("catchAllWithinTestPathFlow")).getMessageSource();
        httpListener.dispose();
        Response response = Request.Get((String)this.getLifecycleConfigUrl("/path/somepath")).execute();
        HttpResponse httoResponse = response.returnResponse();
        Assert.assertThat((Object)httoResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)404));
    }

    @Test
    public void stoppedListenerConfigDoNotListen() throws Exception {
        HttpListenerConfig httpListenerConfig = (HttpListenerConfig)muleContext.getRegistry().get("testLifecycleListenerConfig");
        httpListenerConfig.stop();
        this.expectedException.expect(ConnectException.class);
        Request.Get((String)this.getLifecycleConfigUrl("/path/subpath")).execute();
    }

    @Test
    public void stopOneListenerConfigDoesNotAffectAnother() throws Exception {
        HttpListenerConfig httpListenerConfig = (HttpListenerConfig)muleContext.getRegistry().get("testLifecycleListenerConfig");
        httpListenerConfig.stop();
        this.callAndAssertResponseFromUnaffectedListener();
    }

    @Test
    public void restartListenerConfig() throws Exception {
        HttpListenerConfig httpListenerConfig = (HttpListenerConfig)muleContext.getRegistry().get("testLifecycleListenerConfig");
        httpListenerConfig.stop();
        httpListenerConfig.start();
        Response response = Request.Get((String)this.getLifecycleConfigUrl("/path/anotherPath")).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)"catchAll"));
    }

    private void callAndAssertResponseFromUnaffectedListener() throws IOException {
        Response response = Request.Get((String)this.getUnchangedConfigUrl()).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)"works"));
    }

    private String getLifecycleConfigUrl(String path) {
        return String.format("http://localhost:%s/%s", this.port1.getNumber(), path);
    }

    private String getUnchangedConfigUrl() {
        return String.format("http://localhost:%s/%s", this.port2.getNumber(), "/path");
    }
}

