/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.internal.HttpParser;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpListenerHeaderSizeTestCase
extends FunctionalTestCase {
    private static final int SIZE_DELTA = 1000;
    @Rule
    public SystemProperty maxHeaderSectionSizeSystemProperty = new SystemProperty("mule.http.headerSectionSize", "10000");
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");

    @Test
    public void maxHeaderSizeExceeded() throws Exception {
        MuleMessage response = this.sendRequestWithQueryParam(Integer.valueOf(this.maxHeaderSectionSizeSystemProperty.getValue()) + 1000);
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void maxHeaderSizeNotExceeded() throws Exception {
        int queryParamSize = Integer.valueOf(this.maxHeaderSectionSizeSystemProperty.getValue()) - 1000;
        MuleMessage response = this.sendRequestWithQueryParam(queryParamSize);
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)response.getPayloadAsBytes().length, (Matcher)Is.is((Object)queryParamSize));
    }

    private MuleMessage sendRequestWithQueryParam(int queryParamSize) throws MuleException {
        String longQueryParamValue = RandomStringUtils.randomAlphanumeric((int)queryParamSize);
        String urlWithQueryParameter = HttpParser.appendQueryParam((String)String.format("http://localhost:%d/", this.dynamicPort.getNumber()), (String)"longQueryParam", (String)longQueryParamValue);
        return muleContext.getClient().send(urlWithQueryParameter, this.getTestMuleMessage(), (OperationOptions)HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build());
    }

    protected String getConfigFile() {
        return "http-listener-max-header-size-config.xml";
    }
}

