/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.StringEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class HttpListenerExpressionFilterTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "http-listener-expression-filter-config.xml";
    }

    @Test
    public void returnsEmptyResponseWhenFilteringMessage() throws Exception {
        this.sendRequestAndAssertResponse(false, "");
    }

    @Test
    public void returnsExpectedResponseWhenMessageIsNotFiltered() throws Exception {
        this.sendRequestAndAssertResponse(true, "Test Message");
    }

    private void sendRequestAndAssertResponse(boolean filterExpression, String expectedBody) throws IOException {
        Request request = Request.Post((String)String.format("http://localhost:%s", this.listenPort.getValue())).body((HttpEntity)new StringEntity("Test Message")).addHeader("filterExpression", Boolean.toString(filterExpression));
        HttpResponse response = request.execute().returnResponse();
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)CoreMatchers.equalTo((Object)expectedBody));
    }
}

