/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpListenerContentTypeTestCase
extends FunctionalTestCase {
    private static final String EXPECTED_CONTENT_TYPE = "application/json; charset=UTF-8";
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "http-listener-content-type-config.xml";
    }

    @Test
    public void returnsContentTypeInResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String url = String.format("http://localhost:%s/testInput", this.httpPort.getNumber());
        MuleMessage response = client.send(url, (Object)"Test Message", null);
        this.assertContentTypeProperty(response);
    }

    private void assertContentTypeProperty(MuleMessage response) {
        MatcherAssert.assertThat((Object)response.getInboundPropertyNames(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalToIgnoringCase((String)"Content-Type")));
        MatcherAssert.assertThat((Object)((String)response.getInboundProperty("Content-Type")), (Matcher)Matchers.equalTo((Object)EXPECTED_CONTENT_TYPE));
    }
}

