/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.matcher.HttpResponseStatusCodeMatcher;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

public class HttpListenerConfigFunctionalTestCase
extends FunctionalTestCase {
    private static final Pattern IPADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final int TIMEOUT = 1000;
    private static final HttpRequestOptions GET_OPTIONS = ((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.GET.name()).responseTimeout(1000L)).disableStatusCodeValidation().build();
    @Rule
    public DynamicPort fullConfigPort = new DynamicPort("fullConfigPort");
    @Rule
    public DynamicPort emptyConfigPort = new DynamicPort("emptyConfigPort");
    @Rule
    public DynamicPort noListenerConfigPort = new DynamicPort("noListenerConfigPort");
    @Rule
    public DynamicPort slashConfigPort = new DynamicPort("slashConfigPort");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");
    @Rule
    public SystemProperty basePath = new SystemProperty("basePath", "basePath");
    @Rule
    public SystemProperty nonLocalhostIp = new SystemProperty("nonLocalhostIp", this.getNonLocalhostIp());

    protected String getConfigFile() {
        return "http-listener-config-functional-config.xml";
    }

    @Test
    public void emptyConfig() throws Exception {
        String url = String.format("http://localhost:%s/%s", this.emptyConfigPort.getNumber(), this.path.getValue());
        this.callAndAssertStatus(url, 200);
    }

    @Test
    public void fullConfig() throws Exception {
        String url = String.format("http://localhost:%s/%s/%s", this.fullConfigPort.getNumber(), this.basePath.getValue(), this.path.getValue());
        this.callAndAssertStatus(url, 200);
    }

    @Test
    public void fullConfigWrongPath() throws Exception {
        String url = String.format("http://localhost:%s/%s/%s", this.fullConfigPort.getNumber(), this.basePath.getValue(), this.path.getValue() + "2");
        this.callAndAssertStatus(url, 404);
    }

    @Test
    public void listenerConfigOverridesListenerConfig() throws Exception {
        String url = String.format("http://%s:%s/%s/%s", this.nonLocalhostIp.getValue(), this.fullConfigPort.getNumber(), this.basePath.getValue(), this.path.getValue());
        this.callAndAssertStatus(url, 200);
    }

    @Test
    public void noListenerConfig() throws Exception {
        String url = String.format("http://localhost:%s/noListener", this.noListenerConfigPort.getNumber());
        HttpResponse httpResponse = this.callAndAssertStatus(url, 404);
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)"Resource not found."));
    }

    @Test
    public void fullConfigWrongMethod() throws Exception {
        String url = String.format("http://localhost:%s/%s/%s", this.fullConfigPort.getNumber(), this.basePath.getValue(), "post");
        HttpResponse httpResponse = this.callAndAssertStatus(url, 405);
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.METHOD_NOT_ALLOWED.getReasonPhrase()));
    }

    @Test
    public void useSlashInPathAndBasePath() throws Exception {
        String baseUrl = String.format("http://localhost:%s/", this.slashConfigPort.getNumber());
        Assert.assertThat((Object)this.callAndAssertStatusWithMuleClient(baseUrl + "/", 200), (Matcher)CoreMatchers.is((Object)"1"));
        Assert.assertThat((Object)this.callAndAssertStatusWithMuleClient(baseUrl + "//", 200), (Matcher)CoreMatchers.is((Object)"2"));
        Assert.assertThat((Object)this.callAndAssertStatusWithMuleClient(baseUrl + "///", 200), (Matcher)CoreMatchers.is((Object)"3"));
        this.callAndAssertStatusWithMuleClient(baseUrl + "////", 404);
    }

    private String callAndAssertStatusWithMuleClient(String url, int expectedStatus) throws Exception {
        MuleMessage response = muleContext.getClient().send(url, this.getTestMuleMessage(), (OperationOptions)GET_OPTIONS);
        Assert.assertThat((Object)((Integer)response.getInboundProperty("http.status")), (Matcher)CoreMatchers.is((Object)expectedStatus));
        return IOUtils.toString((InputStream)((InputStream)response.getPayload()));
    }

    private HttpResponse callAndAssertStatus(String url, int expectedStatus) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse, HttpResponseStatusCodeMatcher.hasStatusCode(expectedStatus));
        return httpResponse;
    }

    private String getNonLocalhostIp() {
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || !IPADDRESS_PATTERN.matcher(inetAddress.getHostAddress()).find()) continue;
                    return inetAddress.getHostAddress();
                }
            }
            throw new RuntimeException("Could not find network interface different from localhost");
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }
}

