/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.module.http.internal.multipart.HttpPartDataSource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

public class HttpListenerAttachmentsTestCase
extends FunctionalTestCase {
    private static final String TEXT_BODY_FIELD_NAME = "field1";
    private static final String TEXT_BODY_FIELD_VALUE = "yes";
    private static final String FILE_BODY_FIELD_NAME = "file";
    private static final String FILE_BODY_FIELD_VALUE = RandomStringUtils.randomAlphanumeric((int)1200000);
    private static final String FIELD_BDOY_FILE_NAME = "file.ext";
    private static final String VM_MESSAGE_ENDPOINT = "vm://out";
    private static final boolean DO_NOT_USE_CHUNKED_MODE = false;
    private static final boolean USE_CHUNKED_MODE = true;
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty formDataPath = new SystemProperty("formDataPath", "formDataPath");
    @Rule
    public SystemProperty mixedPath = new SystemProperty("mixedPath", "mixedPath");
    @Rule
    public SystemProperty formDataChunkedPath = new SystemProperty("multipartChunked", "multipartChunked");
    @Rule
    public SystemProperty multipartResponse = new SystemProperty("multipartResponse", "multipartResponse");

    protected String getConfigFile() {
        return "http-listener-attachment-config.xml";
    }

    @Test
    public void receiveOnlyAttachmentsAndReturnOnlyAttachments() throws Exception {
        this.processAttachmentRequestAndResponse(this.formDataPath.getValue(), "multipart/form-data", false);
    }

    @Test
    public void receiveOnlyAttachmentsAndReturnOnlyAttachmentsWithMultipartMixedResponse() throws Exception {
        this.processAttachmentRequestAndResponse(this.mixedPath.getValue(), "multipart/mixed", false);
    }

    @Test
    public void receiveOnlyAttachmentsAndReturnOnlyAttachmentsWithMultipartFormDataAndTransferEncodingChunked() throws Exception {
        this.processAttachmentRequestAndResponse(this.formDataPath.getValue(), "multipart/form-data", true);
    }

    private HttpRequestOptions transferEncodingChunkWithPostOptions() {
        return HttpRequestOptionsBuilder.newOptions().requestStreamingMode(HttpStreamingType.ALWAYS).method(HttpConstants.Methods.POST.name()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttachmentRequestAndResponse(String pathToCall, String expectedResponseContentType, boolean useChunkedMode) throws IOException, MuleException, ServletException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.getUrl(pathToCall));
            HttpEntity multipart = this.createHttpEntity(useChunkedMode);
            httpPost.setEntity(multipart);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                MuleMessage receivedMessage = muleContext.getClient().request(VM_MESSAGE_ENDPOINT, 1000L);
                Assert.assertThat((Object)receivedMessage.getPayload(), (Matcher)Is.is((Object)NullPayload.getInstance()));
                Assert.assertThat((Object)receivedMessage.getInboundAttachmentNames().size(), (Matcher)Is.is((Object)2));
                Assert.assertThat((Object)receivedMessage.getInboundAttachmentNames().contains(TEXT_BODY_FIELD_NAME), (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)new String(((HttpPartDataSource)receivedMessage.getInboundAttachment(TEXT_BODY_FIELD_NAME).getDataSource()).getContent()), (Matcher)Is.is((Object)TEXT_BODY_FIELD_VALUE));
                Assert.assertThat((Object)receivedMessage.getInboundAttachmentNames().contains(FILE_BODY_FIELD_NAME), (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)new String(((HttpPartDataSource)receivedMessage.getInboundAttachment(FILE_BODY_FIELD_NAME).getDataSource()).getContent()), (Matcher)Is.is((Object)FILE_BODY_FIELD_VALUE));
                String contentType = response.getFirstHeader("Content-Type").getValue();
                Assert.assertThat((Object)contentType, (Matcher)Matchers.containsString((String)expectedResponseContentType));
                Collection parts = HttpParser.parseMultipartContent((InputStream)response.getEntity().getContent(), (String)contentType);
                Assert.assertThat((Object)parts.size(), (Matcher)Is.is((Object)2));
                Map<String, Part> partsAsMap = this.convertPartsToMap(parts);
                Assert.assertThat((Object)partsAsMap.get(TEXT_BODY_FIELD_NAME), (Matcher)IsNull.notNullValue());
                Assert.assertThat((Object)partsAsMap.get(FILE_BODY_FIELD_NAME), (Matcher)IsNull.notNullValue());
                Assert.assertThat((Object)IOUtils.toString((InputStream)partsAsMap.get(TEXT_BODY_FIELD_NAME).getInputStream()), (Matcher)Is.is((Object)TEXT_BODY_FIELD_VALUE));
                Assert.assertThat((Object)IOUtils.toString((InputStream)partsAsMap.get(FILE_BODY_FIELD_NAME).getInputStream()), (Matcher)Is.is((Object)FILE_BODY_FIELD_VALUE));
            }
        }
    }

    private HttpEntity createHttpEntity(boolean useChunkedMode) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody(TEXT_BODY_FIELD_NAME, TEXT_BODY_FIELD_VALUE, ContentType.TEXT_PLAIN);
        builder.addBinaryBody(FILE_BODY_FIELD_NAME, FILE_BODY_FIELD_VALUE.getBytes(), ContentType.APPLICATION_OCTET_STREAM, FIELD_BDOY_FILE_NAME);
        HttpEntity multipartEntity = builder.build();
        if (useChunkedMode) {
            ByteArrayOutputStream multipartOutput = new ByteArrayOutputStream();
            multipartEntity.writeTo((OutputStream)multipartOutput);
            multipartOutput.flush();
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(multipartOutput.toByteArray());
            multipartOutput.close();
            byteArrayEntity.setChunked(true);
            byteArrayEntity.setContentEncoding(multipartEntity.getContentEncoding());
            byteArrayEntity.setContentType(multipartEntity.getContentType());
            return byteArrayEntity;
        }
        return multipartEntity;
    }

    private String getUrl(String pathToCall) {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), pathToCall);
    }

    private Map<String, Part> convertPartsToMap(Collection<HttpPart> parts) {
        HashMap<String, Part> partsAsMap = new HashMap<String, Part>();
        for (Part part : parts) {
            partsAsMap.put(part.getName(), part);
        }
        return partsAsMap;
    }
}

