/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.mule.util.concurrent.Latch;

public class TestInputStream
extends InputStream {
    private static final int RECEIVE_TIMEOUT = 5000;
    private final Latch latch;
    private int chunkCount = 0;

    public TestInputStream(Latch latch) {
        this.latch = latch;
    }

    @Override
    public int read() throws IOException {
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        ++this.chunkCount;
        if (this.chunkCount == 1) {
            return b.length;
        }
        this.waitOnLatch();
        return -1;
    }

    private void waitOnLatch() throws IOException {
        if (this.latch != null) {
            try {
                if (!this.latch.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IOException("Latch was never released");
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }
}

