/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.ServerNotificationManager;

public class TestConnectorMessageNotificationListener
implements ServerNotificationListener<ConnectorMessageNotification> {
    private final CountDownLatch latch;
    private final String expectedExchangePoint;
    private List<String> notificationActionNames = new ArrayList<String>();

    public TestConnectorMessageNotificationListener() {
        this.latch = null;
        this.expectedExchangePoint = null;
    }

    public TestConnectorMessageNotificationListener(CountDownLatch latch, String expectedExchangePoint) {
        this.latch = latch;
        this.expectedExchangePoint = expectedExchangePoint;
    }

    public void onNotification(ConnectorMessageNotification notification) {
        this.notificationActionNames.add(notification.getActionName());
        if (this.latch != null) {
            Assert.assertThat((Object)notification.getEndpoint(), (Matcher)Matchers.is((Object)this.expectedExchangePoint));
            this.latch.countDown();
        }
    }

    public List<String> getNotificationActionNames() {
        return this.notificationActionNames;
    }

    public static ServerNotificationManager register(ServerNotificationManager serverNotificationManager) {
        Map mapping = serverNotificationManager.getInterfaceToTypes();
        if (!mapping.containsKey(EndpointMessageNotificationListener.class)) {
            serverNotificationManager.addInterfaceToType(TestConnectorMessageNotificationListener.class, ConnectorMessageNotification.class);
            serverNotificationManager.addListener((ServerNotificationListener)new TestConnectorMessageNotificationListener());
        }
        return serverNotificationManager;
    }
}

