/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@Ignore
public class HttpRequestRecipientListTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");

    protected String getConfigFile() {
        return "http-request-recipient-list-config.xml";
    }

    @Test
    public void recipientListWithHttpUrlsWithResponse() throws Exception {
        MuleEvent testEvent = HttpRequestRecipientListTestCase.getTestEvent((Object)"Test Message");
        testEvent.getMessage().setProperty("urls", Arrays.asList(this.getUrlForPort(this.port1), this.getUrlForPort(this.port2), this.getUrlForPort(this.port3)), PropertyScope.INBOUND);
        MuleEvent response = ((Flow)this.getFlowConstruct("recipientListFlow")).process(testEvent);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getMessage(), (Matcher)IsInstanceOf.instanceOf(MuleMessageCollection.class));
        MuleMessageCollection aggregatedResponse = (MuleMessageCollection)response.getMessage();
        Assert.assertThat((Object)aggregatedResponse.size(), (Matcher)Is.is((Object)3));
        MuleMessage[] messages = aggregatedResponse.getMessagesAsArray();
        for (int i = 0; i < messages.length; ++i) {
            MuleMessage message = messages[i];
            Assert.assertThat((Object)message, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)message.getPayloadAsString(), (Matcher)Is.is((Object)"inXFlowResponse".replace("X", String.valueOf(i + 1))));
        }
    }

    private String getUrlForPort(DynamicPort port) {
        return String.format("http://localhost:%s/path", port.getNumber());
    }
}

