/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.api.requester.proxy;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.http.api.requester.proxy.NtlmProxyConfigBuilder;
import org.mule.module.http.internal.request.NtlmProxyConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class NtlmProxyConfigBuilderTest
extends AbstractMuleTestCase {
    public static final String HOST = "host";
    public static final int PORT = 8080;
    public static final String NTLM_DOMAIN = "DOMAIN";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private NtlmProxyConfigBuilder ntlmProxyConfigBuilder = new NtlmProxyConfigBuilder();

    @Test(expected=IllegalArgumentException.class)
    public void onlyHost() {
        this.ntlmProxyConfigBuilder.setHost(HOST).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void onlyPort() {
        this.ntlmProxyConfigBuilder.setPort(8080).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void onlyDomain() {
        this.ntlmProxyConfigBuilder.setNtlmDomain(NTLM_DOMAIN).build();
    }

    @Test
    public void minimalConfig() {
        NtlmProxyConfig config = (NtlmProxyConfig)this.ntlmProxyConfigBuilder.setHost(HOST).setPort(8080).setNtlmDomain(NTLM_DOMAIN).build();
        Assert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)HOST));
        Assert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        Assert.assertThat((Object)config.getNtlmDomain(), (Matcher)Is.is((Object)NTLM_DOMAIN));
        Assert.assertThat((Object)config.getPassword(), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)config.getUsername(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void fullConfig() {
        NtlmProxyConfig config = (NtlmProxyConfig)this.ntlmProxyConfigBuilder.setHost(HOST).setPort(8080).setNtlmDomain(NTLM_DOMAIN).setUsername(USERNAME).setPassword(PASSWORD).build();
        Assert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)HOST));
        Assert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        Assert.assertThat((Object)config.getNtlmDomain(), (Matcher)Is.is((Object)NTLM_DOMAIN));
        Assert.assertThat((Object)config.getPassword(), (Matcher)Is.is((Object)PASSWORD));
        Assert.assertThat((Object)config.getUsername(), (Matcher)Is.is((Object)USERNAME));
    }
}

