/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.api.requester.authentication;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.module.http.api.requester.authentication.BasicAuthenticationBuilder;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.request.DefaultHttpAuthentication;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class BasicAuthenticationBuilderTestCase
extends AbstractMuleTestCase {
    private static final String PASSWORD = "password";
    private static final String USERNAME = "username";
    private static final String PREEMPTIVE = "preemptiveExpression";
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleEvent mockMuleEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private BasicAuthenticationBuilder builder = new BasicAuthenticationBuilder(this.mockMuleContext);

    @Test
    public void basicConfig() throws MuleException {
        DefaultHttpAuthentication authentication = (DefaultHttpAuthentication)this.builder.setPassword(PASSWORD).setUsername(USERNAME).build();
        Assert.assertThat((Object)authentication.getPassword(), (Matcher)Is.is((Object)PASSWORD));
        Assert.assertThat((Object)authentication.getUsername(), (Matcher)Is.is((Object)USERNAME));
    }

    @Test
    public void basicConfigPreemptive() throws MuleException {
        DefaultHttpAuthentication authentication = (DefaultHttpAuthentication)this.builder.setPreemptive(true).build();
        Assert.assertThat((Object)authentication.getPreemptive(), (Matcher)Is.is((Object)"true"));
    }

    @Test
    public void basicConfigPreemptiveExpression() throws MuleException {
        DefaultHttpAuthentication authentication = (DefaultHttpAuthentication)this.builder.setPreemptiveExpression(PREEMPTIVE).build();
        Assert.assertThat((Object)authentication.getPreemptive(), (Matcher)Is.is((Object)PREEMPTIVE));
    }

    @Test
    public void resolvesExpressionsCorrectly() throws MuleException {
        DefaultHttpAuthentication authentication = (DefaultHttpAuthentication)this.builder.setPassword(PASSWORD).setUsername(USERNAME).build();
        HttpRequestAuthentication requestAuthentication = authentication.resolveRequestAuthentication(this.mockMuleEvent);
        Assert.assertThat((Object)requestAuthentication.getPassword(), (Matcher)Is.is((Object)PASSWORD));
        Assert.assertThat((Object)requestAuthentication.getUsername(), (Matcher)Is.is((Object)USERNAME));
    }
}

