/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.context.WorkManagerSource;
import org.mule.construct.Flow;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.execution.MessageProcessingManager;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.module.http.api.listener.HttpListenerBuilder;
import org.mule.module.http.api.listener.HttpListenerConfig;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ssl.api.TlsContextFactory;

@SmallTest
public class HttpListenerBuilderTestCase
extends AbstractMuleTestCase {
    public static URL TEST_URL;
    public static final String PATH = "somePath";
    public static final int PORT = 1000;
    public static final String HOST = "localhost";
    public static final String IP = "127.0.0.1";
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private TlsContextFactory mockTlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
    private DefaultHttpListenerConfig mockListenerConfig = (DefaultHttpListenerConfig)Mockito.mock(DefaultHttpListenerConfig.class);
    private Flow mockFlow = (Flow)Mockito.mock(Flow.class);
    private MessageProcessingManager mockMessageProcessingManager = (MessageProcessingManager)Mockito.mock(MessageProcessingManager.class);
    private HttpListenerConnectionManager mockListenerConnectionManager = (HttpListenerConnectionManager)Mockito.mock(HttpListenerConnectionManager.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetPortAfterSetUrl() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setUrl(TEST_URL).setPort(1000);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetHostAfterSetUrl() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setUrl(TEST_URL).setHost(HOST);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetPathAfterSetUrl() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setUrl(TEST_URL).setPath(PATH);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetUrlAfterSetHost() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setPort(1000).setUrl(TEST_URL);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetUrltAfterSetPort() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setHost(HOST).setUrl(TEST_URL);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetUrlAfterSetPath() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setPath(PATH).setUrl(TEST_URL);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetTlsContextIfProtocolIsHttp() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setUrl(TEST_URL).setTlsContextFactory(this.mockTlsContextFactory);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetTlsContextIfThereIsAListenerConfig() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setListenerConfig((HttpListenerConfig)this.mockListenerConfig).setTlsContextFactory(this.mockTlsContextFactory);
    }

    @Test(expected=IllegalStateException.class)
    public void doNotAllowSetAListenerConfigIfThereIsATlsContext() throws MalformedURLException {
        new HttpListenerBuilder(this.mockMuleContext).setTlsContextFactory(this.mockTlsContextFactory).setListenerConfig((HttpListenerConfig)this.mockListenerConfig);
    }

    @Test
    public void useExistentListenerConfig() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObject(MessageProcessingManager.class)).thenReturn((Object)this.mockMessageProcessingManager);
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObjects(HttpListenerConfig.class)).thenReturn(Arrays.asList(this.mockListenerConfig));
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObject(HttpListenerConnectionManager.class)).thenReturn((Object)this.mockListenerConnectionManager);
        Mockito.when((Object)this.mockMuleContext.getRegistry().get(Matchers.anyString())).thenReturn(null);
        Mockito.when((Object)this.mockListenerConfig.getPort()).thenReturn((Object)1000);
        Mockito.when((Object)this.mockListenerConfig.getHost()).thenReturn((Object)HOST);
        HttpListener httpListener = new HttpListenerBuilder(this.mockMuleContext).setFlow(this.mockFlow).setHost(HOST).setPort(1000).setPath(PATH).build();
        Assert.assertThat((Object)httpListener.getConfig(), (Matcher)Is.is((Object)this.mockListenerConfig));
    }

    @Test
    public void createListenerConfigIfThereIsNoMatch() throws Exception {
        new HttpListenerBuilder(this.createMuleContext()).setFlow(this.mockFlow).setHost(HOST).setPort(1000).setPath(PATH).build();
        ((HttpListenerConnectionManager)Mockito.verify((Object)this.mockListenerConnectionManager)).createServer((ServerAddress)Matchers.eq((Object)new ServerAddress(IP, 1000)), (WorkManagerSource)Matchers.any(WorkManagerSource.class), Matchers.eq((boolean)true), Matchers.eq((int)30000));
    }

    @Test
    public void createListenerSslConfigIfThereIsNoMatch() throws Exception {
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        new HttpListenerBuilder(this.createMuleContext()).setTlsContextFactory(this.mockTlsContextFactory).setFlow(this.mockFlow).setHost(HOST).setPort(1000).setPath(PATH).build();
        ((HttpListenerConnectionManager)Mockito.verify((Object)this.mockListenerConnectionManager)).createSslServer((ServerAddress)Matchers.eq((Object)new ServerAddress(IP, 1000)), (WorkManagerSource)Matchers.any(WorkManagerSource.class), (TlsContextFactory)Matchers.eq((Object)this.mockTlsContextFactory), Matchers.eq((boolean)true), Matchers.eq((int)30000));
    }

    @Test
    public void useConfiguredListenerConfig() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObject(MessageProcessingManager.class)).thenReturn((Object)this.mockMessageProcessingManager);
        HttpListener httpListener = new HttpListenerBuilder(this.mockMuleContext).setFlow(this.mockFlow).setListenerConfig((HttpListenerConfig)this.mockListenerConfig).setPath(PATH).build();
        Assert.assertThat((Object)httpListener.getConfig(), (Matcher)Is.is((Object)this.mockListenerConfig));
    }

    private MuleContext createMuleContext() throws Exception {
        MuleContext muleContext = new DefaultMuleContextFactory().createMuleContext();
        muleContext.getRegistry().registerObject("_httpListenerConnectionManager", (Object)this.mockListenerConnectionManager);
        return muleContext;
    }

    static {
        try {
            TEST_URL = new URL("http://localhost:1010/path");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

