/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.file.common;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.matcher.FileMatcher;
import org.mule.extension.file.common.api.matcher.MatchPolicy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class FileMatcherContractTestCase<T extends FileMatcher, A extends FileAttributes>
extends AbstractMuleTestCase {
    private static final String FILENAME = "Mule.java";
    private static final String PATH = "a/b/c/Mule.java";
    private static final long SIZE = 1024L;
    protected T builder = this.createPredicateBuilder();
    protected A attributes;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        this.attributes = (FileAttributes)Mockito.mock(this.getFileAttributesClass());
        Mockito.when((Object)this.attributes.getName()).thenReturn((Object)FILENAME);
        Mockito.when((Object)this.attributes.getPath()).thenReturn((Object)PATH);
        Mockito.when((Object)this.attributes.getSize()).thenReturn((Object)1024L);
        Mockito.when((Object)this.attributes.isRegularFile()).thenReturn((Object)true);
        Mockito.when((Object)this.attributes.isSymbolicLink()).thenReturn((Object)false);
        Mockito.when((Object)this.attributes.isDirectory()).thenReturn((Object)false);
    }

    protected T createPredicateBuilder() {
        return (T)((Object)new TestFileMatcher());
    }

    protected Class<A> getFileAttributesClass() {
        return FileAttributes.class;
    }

    @Test
    public void matchesAll() {
        this.builder.setFilenamePattern("glob:*.{java, js}").setPathPattern("glob:**.{java, js}").setRegularFiles(MatchPolicy.REQUIRE).setDirectories(MatchPolicy.EXCLUDE).setSymLinks(MatchPolicy.EXCLUDE).setMinSize(Long.valueOf(1L)).setMaxSize(Long.valueOf(1024L));
        this.assertMatch();
    }

    @Test
    public void matchesManyButFailsOne() {
        this.matchesAll();
        this.builder.setMaxSize(Long.valueOf(1L));
        this.assertReject();
    }

    @Test
    public void matchFilenameLiterally() {
        this.builder.setFilenamePattern(FILENAME);
        this.assertMatch();
    }

    @Test
    public void rejectFilenameLiterally() {
        this.builder.setFilenamePattern("fail.pdf");
        this.assertReject();
    }

    @Test
    public void matchFilenameByGlob() {
        this.builder.setFilenamePattern("glob:*.{java, js}");
        this.assertMatch();
    }

    @Test
    public void rejectFilenameByGlob() {
        this.builder.setFilenamePattern("glob:*.{pdf}");
        this.assertReject();
    }

    @Test
    public void matchFilenameByRegex() {
        Mockito.when((Object)this.attributes.getName()).thenReturn((Object)"20060101_test.csv");
        this.builder.setFilenamePattern("regex:[0-9]*_test.csv");
        this.assertMatch();
    }

    @Test
    public void rejectFilenameByRegex() {
        Mockito.when((Object)this.attributes.getName()).thenReturn((Object)"20060101_TEST.csv");
        this.builder.setFilenamePattern("regex:[0-9]*_test.csv");
        this.assertReject();
    }

    @Test
    public void matchPathLiterally() {
        this.builder.setPathPattern(PATH);
        this.assertMatch();
    }

    @Test
    public void rejectPathLiterally() {
        this.builder.setPathPattern("a/b/d/Mule.pdf");
        this.assertReject();
    }

    @Test
    public void matchPathByGlob() {
        this.builder.setPathPattern("glob:**.{java, js}");
        this.assertMatch();
    }

    @Test
    public void rejectPathByGlob() {
        this.builder.setPathPattern("glob:*.{java, js}");
        this.assertReject();
    }

    @Test
    public void matchPathByRegex() {
        Mockito.when((Object)this.attributes.getPath()).thenReturn((Object)"a/b/c/20060101_test.csv");
        this.builder.setPathPattern("regex:a/b/c/[0-9]*_test.csv");
        this.assertMatch();
    }

    @Test
    public void rejectPathByRegex() {
        Mockito.when((Object)this.attributes.getName()).thenReturn((Object)"20060101_TEST.csv");
        this.builder.setFilenamePattern("regex:[0-9]*_test.csv");
        this.assertReject();
    }

    @Test
    public void minSize() {
        this.builder.setMinSize(Long.valueOf(1L));
        this.assertMatch();
    }

    @Test
    public void maxSize() {
        this.builder.setMaxSize(Long.valueOf(1024L));
        this.assertMatch();
    }

    @Test
    public void rejectMinSize() {
        this.builder.setMinSize(Long.valueOf(2048L));
        this.assertReject();
    }

    @Test
    public void rejectMaxSize() {
        this.builder.setMaxSize(Long.valueOf(500L));
        this.assertReject();
    }

    @Test
    public void regularFile() {
        Mockito.when((Object)this.attributes.isRegularFile()).thenReturn((Object)true);
        this.builder.setRegularFiles(MatchPolicy.REQUIRE);
        this.assertMatch();
    }

    @Test
    public void rejectNotRegularFile() {
        Mockito.when((Object)this.attributes.isRegularFile()).thenReturn((Object)false);
        this.builder.setRegularFiles(MatchPolicy.REQUIRE);
        this.assertReject();
    }

    @Test
    public void rejectRegularFile() {
        Mockito.when((Object)this.attributes.isRegularFile()).thenReturn((Object)true);
        this.builder.setRegularFiles(MatchPolicy.EXCLUDE);
        this.assertReject();
    }

    @Test
    public void isDirectory() {
        Mockito.when((Object)this.attributes.isDirectory()).thenReturn((Object)true);
        this.builder.setDirectories(MatchPolicy.REQUIRE);
        this.assertMatch();
    }

    @Test
    public void rejectNotDirectory() {
        Mockito.when((Object)this.attributes.isDirectory()).thenReturn((Object)false);
        this.builder.setDirectories(MatchPolicy.REQUIRE);
        this.assertReject();
    }

    @Test
    public void rejectDirectory() {
        Mockito.when((Object)this.attributes.isDirectory()).thenReturn((Object)true);
        this.builder.setDirectories(MatchPolicy.EXCLUDE);
        this.assertReject();
    }

    @Test
    public void isSymbolicLink() {
        Mockito.when((Object)this.attributes.isSymbolicLink()).thenReturn((Object)true);
        this.builder.setSymLinks(MatchPolicy.REQUIRE);
        this.assertMatch();
    }

    @Test
    public void rejectNotSymbolicLink() {
        Mockito.when((Object)this.attributes.isSymbolicLink()).thenReturn((Object)false);
        this.builder.setSymLinks(MatchPolicy.REQUIRE);
        this.assertReject();
    }

    @Test
    public void rejectSymbolicLink() {
        Mockito.when((Object)this.attributes.isSymbolicLink()).thenReturn((Object)true);
        this.builder.setSymLinks(MatchPolicy.EXCLUDE);
        this.assertReject();
    }

    @Test
    public void failOnInvalidMinSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.setMinSize(Long.valueOf(-1L));
        this.builder.build();
    }

    @Test
    public void failOnInvalidMaxSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.setMaxSize(Long.valueOf(-1L));
        this.builder.build();
    }

    protected void assertMatch() {
        Assert.assertThat((Object)this.builder.build().test(this.attributes), (Matcher)CoreMatchers.is((Object)true));
    }

    protected void assertReject() {
        Assert.assertThat((Object)this.builder.build().test(this.attributes), (Matcher)CoreMatchers.is((Object)false));
    }

    private class TestFileMatcher
    extends FileMatcher {
        private TestFileMatcher() {
        }
    }
}

