/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.file.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.extension.file.common.api.AbstractFileSystem;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.command.CopyCommand;
import org.mule.extension.file.common.api.command.CreateDirectoryCommand;
import org.mule.extension.file.common.api.command.DeleteCommand;
import org.mule.extension.file.common.api.command.ListCommand;
import org.mule.extension.file.common.api.command.MoveCommand;
import org.mule.extension.file.common.api.command.ReadCommand;
import org.mule.extension.file.common.api.command.RenameCommand;
import org.mule.extension.file.common.api.command.WriteCommand;
import org.mule.extension.file.common.api.lock.NullPathLock;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConcurrentLockTestCase {
    private static final Path PATH = Paths.get("lock", new String[0]);
    private static final int TIMEOUT = 5;
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    private AbstractFileSystem fileSystem = new TestFileSystem("");
    private Latch mainThreadLatch = new Latch();
    private Latch secondaryThreadLatch = new Latch();
    private CountDownLatch assertionLatch = new CountDownLatch(2);
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger successful = new AtomicInteger(0);

    @Test
    public void concurrentLock() throws Exception {
        new Thread(() -> {
            try {
                this.mainThreadLatch.release();
                this.secondaryThreadLatch.await(5L, TIMEOUT_UNIT);
                this.tryLock();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).start();
        this.mainThreadLatch.await(5L, TIMEOUT_UNIT);
        this.secondaryThreadLatch.release();
        this.tryLock();
        this.assertionLatch.await(5L, TIMEOUT_UNIT);
        Assert.assertThat((Object)this.successful.get(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.failed.get(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void tryLock() {
        try {
            if (this.fileSystem.lock(PATH, new Object[0]).tryLock()) {
                this.successful.incrementAndGet();
            } else {
                this.failed.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failed.incrementAndGet();
        }
        this.assertionLatch.countDown();
    }

    private class TestFileSystem
    extends AbstractFileSystem {
        private boolean locked;

        public TestFileSystem(String basePath) {
            super(basePath);
            this.locked = false;
        }

        protected ListCommand getListCommand() {
            return null;
        }

        protected ReadCommand getReadCommand() {
            return null;
        }

        protected WriteCommand getWriteCommand() {
            return null;
        }

        protected CopyCommand getCopyCommand() {
            return null;
        }

        protected MoveCommand getMoveCommand() {
            return null;
        }

        protected DeleteCommand getDeleteCommand() {
            return null;
        }

        protected RenameCommand getRenameCommand() {
            return null;
        }

        protected CreateDirectoryCommand getCreateDirectoryCommand() {
            return null;
        }

        protected PathLock createLock(Path path, Object ... params) {
            if (this.locked) {
                PathLock lock = (PathLock)Mockito.mock(PathLock.class);
                Mockito.when((Object)lock.tryLock()).thenReturn((Object)false);
                return lock;
            }
            this.locked = true;
            return new NullPathLock();
        }

        public void changeToBaseDir() {
        }

        public Class<? extends FileAttributes> getAttributesType() {
            return FileAttributes.class;
        }
    }
}

