/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.common.api.stream.LazyStreamSupplier;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public abstract class AbstractFileInputStream
extends AutoCloseInputStream {
    private final LazyStreamSupplier streamSupplier;
    private final PathLock lock;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private static InputStream createLazyStream(LazyStreamSupplier streamFactory) {
        return (InputStream)Enhancer.create(InputStream.class, (Callback)((MethodInterceptor)(proxy, method, arguments, methodProxy) -> methodProxy.invoke((Object)streamFactory.get(), arguments)));
    }

    public AbstractFileInputStream(LazyStreamSupplier streamSupplier, PathLock lock) {
        super(AbstractFileInputStream.createLazyStream(streamSupplier));
        this.lock = lock;
        this.streamSupplier = streamSupplier;
    }

    public final synchronized void close() throws IOException {
        try {
            if (this.closed.compareAndSet(false, true) && this.streamSupplier.isSupplied()) {
                this.doClose();
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void doClose() throws IOException {
        super.close();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

