/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.matcher;

import java.util.function.Predicate;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.matcher.MatchPolicy;
import org.mule.extension.file.common.api.matcher.PathMatcherPredicate;
import org.mule.extension.file.common.api.util.TimeSinceFunction;
import org.mule.extension.file.common.api.util.TimeUntilFunction;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class FileMatcher<T extends FileMatcher, A extends FileAttributes> {
    private static final String SIZE_MUST_BE_GREATER_THAN_ZERO_MESSAGE = "Matcher attribute '%s' must be greater than zero but '%d' was received";
    protected static final TimeUntilFunction FILE_TIME_UNTIL = new TimeUntilFunction();
    protected static final TimeSinceFunction FILE_TIME_SINCE = new TimeSinceFunction();
    @Parameter
    @Optional
    @Summary(value="A matching pattern to be applied on the file name.")
    private String filenamePattern;
    @Parameter
    @Optional
    @Summary(value="A matching pattern to be applied on the file path")
    private String pathPattern;
    @Parameter
    @Optional(defaultValue="INCLUDE")
    @Summary(value="Indicates whether accept only directories or non directories files")
    private MatchPolicy directories = MatchPolicy.INCLUDE;
    @Parameter
    @Optional(defaultValue="INCLUDE")
    @Summary(value="Indicates whether accept only regular files (files which are not directories, nor symbolic links) or only not regular files")
    private MatchPolicy regularFiles = MatchPolicy.INCLUDE;
    @Parameter
    @Optional(defaultValue="INCLUDE")
    @Summary(value="Indicates whether accept only symbolic links files or accept only not symbolic links files")
    private MatchPolicy symLinks = MatchPolicy.INCLUDE;
    @Parameter
    @Optional
    private Long minSize;
    @Parameter
    @Optional
    private Long maxSize;

    public Predicate<A> build() {
        PathMatcherPredicate pathMatcher;
        Predicate<FileAttributes> predicate = payload -> true;
        if (this.filenamePattern != null) {
            pathMatcher = new PathMatcherPredicate(this.filenamePattern);
            predicate = predicate.and(payload -> pathMatcher.test(payload.getName()));
        }
        if (this.pathPattern != null) {
            pathMatcher = new PathMatcherPredicate(this.pathPattern);
            predicate = predicate.and(payload -> pathMatcher.test(payload.getPath()));
        }
        if (!this.directories.acceptsAll()) {
            predicate = predicate.and(attributes -> this.directories.asBoolean().get().equals(attributes.isDirectory()));
        }
        if (!this.regularFiles.acceptsAll()) {
            predicate = predicate.and(attributes -> this.regularFiles.asBoolean().get().equals(attributes.isRegularFile()));
        }
        if (!this.symLinks.acceptsAll()) {
            predicate = predicate.and(attributes -> this.symLinks.asBoolean().get().equals(attributes.isSymbolicLink()));
        }
        if (this.minSize != null) {
            Preconditions.checkArgument((this.minSize > 0L ? 1 : 0) != 0, (String)String.format(SIZE_MUST_BE_GREATER_THAN_ZERO_MESSAGE, "minSize", this.minSize));
            predicate = predicate.and(attributes -> attributes.getSize() >= this.minSize);
        }
        if (this.maxSize != null) {
            Preconditions.checkArgument((this.maxSize > 0L ? 1 : 0) != 0, (String)String.format(SIZE_MUST_BE_GREATER_THAN_ZERO_MESSAGE, "maxSize", this.maxSize));
            predicate = predicate.and(attributes -> attributes.getSize() <= this.maxSize);
        }
        return this.addConditions(predicate);
    }

    protected Predicate<A> addConditions(Predicate<A> predicate) {
        return predicate;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public MatchPolicy getDirectories() {
        return this.directories;
    }

    public MatchPolicy getRegularFiles() {
        return this.regularFiles;
    }

    public MatchPolicy getSymLinks() {
        return this.symLinks;
    }

    public Long getMinSize() {
        return this.minSize;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public T setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
        return (T)this;
    }

    public T setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
        return (T)this;
    }

    public T setDirectories(MatchPolicy directories) {
        this.directories = directories;
        return (T)this;
    }

    public T setRegularFiles(MatchPolicy regularFiles) {
        this.regularFiles = regularFiles;
        return (T)this;
    }

    public T setSymLinks(MatchPolicy symLinks) {
        this.symLinks = symLinks;
        return (T)this;
    }

    public T setMinSize(Long minSize) {
        this.minSize = minSize;
        return (T)this;
    }

    public T setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
        return (T)this;
    }
}

