/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.lock;

import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.runtime.api.lock.LockFactory;

public class URLPathLock
implements PathLock {
    private final URL url;
    private final LockFactory lockFactory;
    private final AtomicReference<Lock> ownedLock = new AtomicReference();

    public URLPathLock(URL url, LockFactory lockFactory) {
        this.url = url;
        this.lockFactory = lockFactory;
    }

    @Override
    public boolean tryLock() {
        Lock lock = this.getLock();
        if (lock.tryLock()) {
            this.ownedLock.set(lock);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLocked() {
        if (this.ownedLock.get() != null) {
            return true;
        }
        Lock lock = this.getLock();
        try {
            boolean bl = !lock.tryLock();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void release() {
        Lock lock = this.ownedLock.getAndSet(null);
        if (lock != null) {
            lock.unlock();
        }
    }

    private Lock getLock() {
        return this.lockFactory.createLock(this.url.toExternalForm());
    }
}

