/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.command;

import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileCommand<F extends FileSystem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCommand.class);
    protected final F fileSystem;

    protected FileCommand(F fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected abstract boolean exists(Path var1);

    protected void assureParentFolderExists(Path path, boolean createParentFolder) {
        if (this.exists(path)) {
            return;
        }
        Path parentFolder = path.getParent();
        if (!this.exists(parentFolder)) {
            if (createParentFolder) {
                this.mkdirs(parentFolder);
            } else {
                throw new IllegalPathException(String.format("Cannot write to file '%s' because path to it doesn't exist. Consider setting the 'createParentDirectories' attribute to 'true'", path));
            }
        }
    }

    protected final void mkdirs(Path directoryPath) {
        Lock lock = this.fileSystem.createMuleLock(String.format("%s-mkdirs-%s", this.getClass().getName(), directoryPath));
        lock.lock();
        try {
            if (this.exists(directoryPath)) {
                return;
            }
            this.doMkDirs(directoryPath);
        }
        finally {
            lock.unlock();
        }
        LOGGER.debug("Directory '{}' created", (Object)directoryPath);
    }

    protected abstract void doMkDirs(Path var1);

    protected Path resolvePath(String filePath) {
        Path path = this.getBasePath((FileSystem)this.fileSystem);
        if (filePath != null) {
            path = path.resolve(filePath);
        }
        return path.toAbsolutePath();
    }

    protected abstract Path getBasePath(FileSystem var1);

    protected Path resolveExistingPath(String filePath) {
        Path path = this.resolvePath(filePath);
        if (!this.exists(path)) {
            throw this.pathNotFoundException(path);
        }
        return path;
    }

    public RuntimeException exception(String message) {
        return new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
    }

    public RuntimeException exception(String message, Exception cause) {
        return new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)cause);
    }

    protected boolean isVirtualDirectory(String fileName) {
        return ".".equals(fileName) || "..".equals(fileName);
    }

    protected IllegalPathException cannotReadDirectoryException(Path path) {
        return new IllegalPathException(String.format("Cannot read path '%s' since it's a directory", path));
    }

    protected IllegalPathException cannotListFileException(Path path) {
        return new IllegalPathException(String.format("Cannot list path '%s' because it's a file. Only directories can be listed", path));
    }

    protected IllegalPathException pathNotFoundException(Path path) {
        return new IllegalPathException(String.format("Path '%s' doesn't exists", path));
    }

    public FileAlreadyExistsException alreadyExistsException(Path path) {
        return new FileAlreadyExistsException(String.format("'%s' already exists. Set the 'overwrite' parameter to 'true' to perform the operation anyway", path));
    }
}

