/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Predicate;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.FileWriteMode;
import org.mule.extension.file.common.api.exceptions.IllegalContentException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.extension.file.common.api.matcher.FileMatcher;
import org.mule.extension.file.common.api.matcher.NullFilePayloadPredicate;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.operation.Result;

public abstract class BaseFileSystemOperations {
    protected List<Result<InputStream, FileAttributes>> doList(FileConnectorConfig config, FileSystem fileSystem, String directoryPath, boolean recursive, MediaType mediaType, FileMatcher matchWith) {
        fileSystem.changeToBaseDir();
        return fileSystem.list(config, directoryPath, recursive, mediaType, this.getPredicate(matchWith));
    }

    protected Result<InputStream, FileAttributes> doRead(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @DisplayName(value="File Path") String path, MediaType mediaType, @Optional(defaultValue="false") @Placement(tab="Advanced") boolean lock) {
        fileSystem.changeToBaseDir();
        return fileSystem.read(config, path, mediaType, lock);
    }

    protected void doWrite(FileConnectorConfig config, FileSystem fileSystem, String path, InputStream content, String encoding, boolean createParentDirectories, boolean lock, FileWriteMode mode) {
        if (content == null) {
            throw new IllegalContentException("Cannot write a null content");
        }
        this.validatePath(path, "path");
        fileSystem.changeToBaseDir();
        if (encoding == null) {
            encoding = config.getDefaultWriteEncoding();
        }
        fileSystem.write(path, content, mode, lock, createParentDirectories, encoding);
    }

    protected void doCopy(FileConnectorConfig config, FileSystem fileSystem, String sourcePath, String targetPath, boolean createParentDirectories, boolean overwrite, String renameTo) {
        fileSystem.changeToBaseDir();
        this.validatePath(targetPath, "target path");
        this.validatePath(sourcePath, "source path");
        fileSystem.copy(config, sourcePath, targetPath, overwrite, createParentDirectories, renameTo);
    }

    protected void doMove(FileConnectorConfig config, FileSystem fileSystem, String sourcePath, String targetPath, boolean createParentDirectories, boolean overwrite, String renameTo) {
        fileSystem.changeToBaseDir();
        this.validatePath(targetPath, "target path");
        this.validatePath(sourcePath, "source path");
        fileSystem.move(config, sourcePath, targetPath, overwrite, createParentDirectories, renameTo);
    }

    protected void doDelete(FileSystem fileSystem, @Optional String path) {
        fileSystem.changeToBaseDir();
        fileSystem.delete(path);
    }

    protected void doRename(@Connection FileSystem fileSystem, @Optional String path, @DisplayName(value="New Name") String to, @Optional(defaultValue="false") boolean overwrite) {
        if (Paths.get(to, new String[0]).getNameCount() != 1) {
            throw new IllegalPathException(String.format("'to' parameter of rename operation should not contain any file separator character but '%s' was received", to));
        }
        fileSystem.changeToBaseDir();
        fileSystem.rename(path, to, overwrite);
    }

    protected void doCreateDirectory(@Connection FileSystem fileSystem, String directoryPath) {
        this.validatePath(directoryPath, "directory path");
        fileSystem.changeToBaseDir();
        fileSystem.createDirectory(directoryPath);
    }

    private void validatePath(String path, String pathName) {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalPathException(String.format("%s cannot be null nor blank", pathName));
        }
    }

    private Predicate<FileAttributes> getPredicate(FileMatcher builder) {
        return builder != null ? builder.build() : new NullFilePayloadPredicate<FileAttributes>();
    }
}

