/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.FileWriteMode;
import org.mule.extension.file.common.api.command.CopyCommand;
import org.mule.extension.file.common.api.command.CreateDirectoryCommand;
import org.mule.extension.file.common.api.command.DeleteCommand;
import org.mule.extension.file.common.api.command.ListCommand;
import org.mule.extension.file.common.api.command.MoveCommand;
import org.mule.extension.file.common.api.command.ReadCommand;
import org.mule.extension.file.common.api.command.RenameCommand;
import org.mule.extension.file.common.api.command.WriteCommand;
import org.mule.extension.file.common.api.exceptions.FileLockedException;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.runtime.operation.Result;

public abstract class AbstractFileSystem
implements FileSystem {
    private final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    @Inject
    private MuleContext muleContext;
    private final String basePath;

    public AbstractFileSystem(String basePath) {
        this.basePath = basePath;
    }

    protected abstract ListCommand getListCommand();

    protected abstract ReadCommand getReadCommand();

    protected abstract WriteCommand getWriteCommand();

    protected abstract CopyCommand getCopyCommand();

    protected abstract MoveCommand getMoveCommand();

    protected abstract DeleteCommand getDeleteCommand();

    protected abstract RenameCommand getRenameCommand();

    protected abstract CreateDirectoryCommand getCreateDirectoryCommand();

    @Override
    public List<Result<InputStream, FileAttributes>> list(FileConnectorConfig config, String directoryPath, boolean recursive, MediaType mediaType, Predicate<FileAttributes> matcher) {
        return this.getListCommand().list(config, directoryPath, recursive, mediaType, matcher);
    }

    @Override
    public Result<InputStream, FileAttributes> read(FileConnectorConfig config, String filePath, MediaType mediaType, boolean lock) {
        return this.getReadCommand().read(config, filePath, mediaType, lock);
    }

    @Override
    public void write(String filePath, InputStream content, FileWriteMode mode, boolean lock, boolean createParentDirectories, String encoding) {
        this.getWriteCommand().write(filePath, content, mode, lock, createParentDirectories, encoding);
    }

    @Override
    public void copy(FileConnectorConfig config, String sourcePath, String targetDirectory, boolean overwrite, boolean createParentDirectories, String renameTo) {
        this.getCopyCommand().copy(config, sourcePath, targetDirectory, overwrite, createParentDirectories, renameTo);
    }

    @Override
    public void move(FileConnectorConfig config, String sourcePath, String targetDirectory, boolean overwrite, boolean createParentDirectories, String renameTo) {
        this.getMoveCommand().move(config, sourcePath, targetDirectory, overwrite, createParentDirectories, renameTo);
    }

    @Override
    public void delete(String filePath) {
        this.getDeleteCommand().delete(filePath);
    }

    @Override
    public final void rename(String filePath, String newName, boolean overwrite) {
        this.getRenameCommand().rename(filePath, newName, overwrite);
    }

    @Override
    public void createDirectory(String directoryName) {
        this.getCreateDirectoryCommand().createDirectory(directoryName);
    }

    @Override
    public final synchronized PathLock lock(Path path, Object ... params) {
        PathLock lock = this.createLock(path, params);
        if (!lock.tryLock()) {
            throw new FileLockedException(String.format("Could not lock file '%s' because it's already owned by another process", path));
        }
        return lock;
    }

    @Override
    public MediaType getFileMessageMediaType(MediaType originalMediaType, FileAttributes attributes) {
        MediaType presumedMimeType = MediaType.parse((String)this.mimetypesFileTypeMap.getContentType(attributes.getPath()));
        MediaType mediaType = presumedMimeType != null ? presumedMimeType : originalMediaType;
        return originalMediaType.getCharset().map(charset -> mediaType.withCharset(charset)).orElse(mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLocked(Path path) {
        PathLock lock = this.createLock(path, new Object[0]);
        try {
            boolean bl = !lock.tryLock();
            return bl;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void verifyNotLocked(Path path) {
        if (this.isLocked(path)) {
            throw new FileLockedException(String.format("File '%s' is locked by another process", path));
        }
    }

    protected abstract PathLock createLock(Path var1, Object ... var2);

    @Override
    public Lock createMuleLock(String lockId) {
        return this.muleContext.getLockFactory().createLock(lockId);
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }
}

