/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.DefaultOperationContext;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperationMessageProcessor
implements MessageProcessor,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationMessageProcessor.class);
    private final Extension extension;
    private final String configurationInstanceProviderName;
    private final Operation operation;
    private final ResolverSet resolverSet;
    private final ExtensionManagerAdapter extensionManager;
    private MuleContext muleContext;
    private OperationExecutor operationExecutor;

    public OperationMessageProcessor(Extension extension, Operation operation, String configurationInstanceProviderName, ResolverSet resolverSet, ExtensionManagerAdapter extensionManager) {
        this.extension = extension;
        this.operation = operation;
        this.configurationInstanceProviderName = configurationInstanceProviderName;
        this.resolverSet = resolverSet;
        this.extensionManager = extensionManager;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        OperationContext operationContext = this.createOperationContext(event);
        Object result = this.executeOperation(operationContext);
        if (result instanceof MuleEvent) {
            return (MuleEvent)result;
        }
        if (result instanceof MuleMessage) {
            event.setMessage((MuleMessage)result);
        } else {
            event.getMessage().setPayload(result);
        }
        return event;
    }

    private Object executeOperation(OperationContext operationContext) throws MuleException {
        try {
            return this.operationExecutor.execute(operationContext);
        }
        catch (Exception e) {
            throw this.handledException(operationContext, e);
        }
    }

    private MuleException handledException(OperationContext operationContext, Exception e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        if (root == null) {
            root = e;
        }
        return new MessagingException(MessageFactory.createStaticMessage((String)root.getMessage()), ((OperationContextAdapter)operationContext).getEvent(), root, (MessageProcessor)this);
    }

    private OperationContext createOperationContext(MuleEvent event) throws MuleException {
        ResolverSetResult parameters = this.resolverSet.resolve(event);
        return new DefaultOperationContext(this.extension, this.operation, this.configurationInstanceProviderName, parameters, event, this.extensionManager);
    }

    public void initialise() throws InitialisationException {
        this.operationExecutor = this.operation.getExecutor();
        LifecycleUtils.initialiseIfNeeded((Object)this.operationExecutor, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.operationExecutor);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.operationExecutor);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.operationExecutor, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

