/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extension.introspection.Extension;
import org.mule.module.extension.internal.manager.ExtensionStateTracker;
import org.mule.util.CollectionUtils;

final class ExtensionRegistry {
    private final LoadingCache<Extension, ExtensionStateTracker> extensionStates = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Extension, ExtensionStateTracker>(){

        public ExtensionStateTracker load(Extension key) throws Exception {
            return new ExtensionStateTracker();
        }
    });
    private final Map<String, Extension> extensions = new ConcurrentHashMap<String, Extension>();
    private final Map<Class<?>, Set<Extension>> capabilityToExtension = new ConcurrentHashMap();

    ExtensionRegistry() {
    }

    void registerExtension(String name, Extension extension) {
        this.extensions.put(name, extension);
    }

    Set<Extension> getExtensions() {
        return ImmutableSet.copyOf(this.extensions.values());
    }

    boolean containsExtension(String name) {
        return this.extensions.containsKey(name);
    }

    Extension getExtension(String name) {
        return this.extensions.get(name);
    }

    ExtensionStateTracker getExtensionState(Extension extension) {
        return (ExtensionStateTracker)this.extensionStates.getUnchecked((Object)extension);
    }

    <C> Set<Extension> getExtensionsCapableOf(Class<C> capabilityType) {
        ImmutableSet cachedCapables = this.capabilityToExtension.get(capabilityType);
        if (CollectionUtils.isEmpty(cachedCapables)) {
            ImmutableSet.Builder capables = ImmutableSet.builder();
            for (Extension extension : this.getExtensions()) {
                if (!extension.isCapableOf(capabilityType)) continue;
                capables.add((Object)extension);
            }
            cachedCapables = capables.build();
            this.capabilityToExtension.put(capabilityType, (Set<Extension>)cachedCapables);
        }
        return cachedCapables;
    }
}

