/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import junit.framework.Assert;
import org.junit.Test;
import org.mule.extension.introspection.DataType;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.Kiwi;

@SmallTest
public class IntrospectionUtilsTestCase
extends AbstractMuleTestCase {
    private List<FruitBasket> baskets;

    @Test
    public void getMethodReturnType() throws Exception {
        DataType type = IntrospectionUtils.getMethodReturnType((Method)this.getMethod("foo", new Class[0]));
        Assert.assertEquals(Map.class, (Object)type.getRawType());
        DataType[] genericTypes = type.getGenericTypes();
        Assert.assertEquals((int)2, (int)genericTypes.length);
        this.assertType(genericTypes[0], String.class, new Class[0]);
        this.assertType(genericTypes[1], Apple.class, new Class[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodReturnType() throws Exception {
        IntrospectionUtils.getMethodReturnType(null);
    }

    @Test
    public void getArgumentlessMethodArgumentTypes() throws Exception {
        DataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)this.getMethod("foo", new Class[0]));
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((int)0, (int)types.length);
    }

    @Test
    public void getMethodArgumentTypes() throws Exception {
        DataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)this.getMethod("bar", String.class, Long.class, Apple.class, Map.class));
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((int)4, (int)types.length);
        this.assertType(types[0], String.class, new Class[0]);
        this.assertType(types[1], Long.class, new Class[0]);
        this.assertType(types[2], Apple.class, new Class[0]);
        this.assertType(types[3], Map.class, Banana.class, Kiwi.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodArgumentTypes() throws Exception {
        IntrospectionUtils.getMethodArgumentTypes(null);
    }

    @Test
    public void getFieldDataType() throws Exception {
        DataType type = IntrospectionUtils.getFieldDataType((Field)((Object)((Object)this)).getClass().getDeclaredField("baskets"));
        this.assertType(type, List.class, FruitBasket.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullFieldDataType() throws Exception {
        IntrospectionUtils.getFieldDataType(null);
    }

    private void assertType(DataType type, Class<?> rawType, Class<?> ... genericTypes) {
        Assert.assertEquals(rawType, (Object)type.getRawType());
        if (genericTypes != null) {
            Assert.assertEquals((int)genericTypes.length, (int)type.getGenericTypes().length);
            for (int i = 0; i < genericTypes.length; ++i) {
                Assert.assertEquals(genericTypes[i], (Object)type.getGenericTypes()[i].getRawType());
            }
        }
    }

    private Method getMethod(String methodName, Class<?> ... parameterTypes) throws Exception {
        return ((Object)((Object)this)).getClass().getMethod(methodName, parameterTypes);
    }

    public Map<String, Apple> foo() {
        return new HashMap<String, Apple>();
    }

    public int bar(String s, Long l, Apple apple, Map<Banana, Kiwi> fruits) {
        return Objects.hash(s, l, apple, fruits);
    }

    public List<FruitBasket> getBaskets() {
        return this.baskets;
    }

    public void setBaskets(List<FruitBasket> baskets) {
        this.baskets = baskets;
    }
}

